/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing the response for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeResourceRecordSetsResponse extends Route53Response implements
        ToCopyableBuilder<ChangeResourceRecordSetsResponse.Builder, ChangeResourceRecordSetsResponse> {
    private final ChangeInfo changeInfo;

    private ChangeResourceRecordSetsResponse(BuilderImpl builder) {
        super(builder);
        this.changeInfo = builder.changeInfo;
    }

    /**
     * <p>
     * A complex type that contains information about changes made to your hosted zone.
     * </p>
     * <p>
     * This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed information
     * about the change.
     * </p>
     * 
     * @return A complex type that contains information about changes made to your hosted zone.</p>
     *         <p>
     *         This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
     *         information about the change.
     */
    public ChangeInfo changeInfo() {
        return changeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeResourceRecordSetsResponse)) {
            return false;
        }
        ChangeResourceRecordSetsResponse other = (ChangeResourceRecordSetsResponse) obj;
        return Objects.equals(changeInfo(), other.changeInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("ChangeResourceRecordSetsResponse").add("ChangeInfo", changeInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeInfo":
            return Optional.of(clazz.cast(changeInfo()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ChangeResourceRecordSetsResponse> {
        /**
         * <p>
         * A complex type that contains information about changes made to your hosted zone.
         * </p>
         * <p>
         * This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
         * information about the change.
         * </p>
         * 
         * @param changeInfo
         *        A complex type that contains information about changes made to your hosted zone.</p>
         *        <p>
         *        This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
         *        information about the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeInfo(ChangeInfo changeInfo);

        /**
         * <p>
         * A complex type that contains information about changes made to your hosted zone.
         * </p>
         * <p>
         * This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
         * information about the change.
         * </p>
         * This is a convenience that creates an instance of the {@link ChangeInfo.Builder} avoiding the need to create
         * one manually via {@link ChangeInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChangeInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #changeInfo(ChangeInfo)}.
         * 
         * @param changeInfo
         *        a consumer that will call methods on {@link ChangeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeInfo(ChangeInfo)
         */
        default Builder changeInfo(Consumer<ChangeInfo.Builder> changeInfo) {
            return changeInfo(ChangeInfo.builder().apply(changeInfo).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private ChangeInfo changeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeResourceRecordSetsResponse model) {
            changeInfo(model.changeInfo);
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return changeInfo != null ? changeInfo.toBuilder() : null;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        @Override
        public ChangeResourceRecordSetsResponse build() {
            return new ChangeResourceRecordSetsResponse(this);
        }
    }
}
