/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateQueryLoggingConfigRequest extends Route53Request implements
        ToCopyableBuilder<CreateQueryLoggingConfigRequest.Builder, CreateQueryLoggingConfigRequest> {
    private final String hostedZoneId;

    private final String cloudWatchLogsLogGroupArn;

    private CreateQueryLoggingConfigRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.
     * </p>
     * 
     * @return The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted
     *         zones.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is
     * the format of the ARN:
     * </p>
     * <p>
     * arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
     * </p>
     * <p>
     * To get the ARN for a log group, you can use the CloudWatch console, the <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
     * >DescribeLogGroups</a> API action, the <a
     * href="http://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a>
     * command, or the applicable command in one of the AWS SDKs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to.
     *         This is the format of the ARN:</p>
     *         <p>
     *         arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
     *         </p>
     *         <p>
     *         To get the ARN for a log group, you can use the CloudWatch console, the <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
     *         >DescribeLogGroups</a> API action, the <a
     *         href="http://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html"
     *         >describe-log-groups</a> command, or the applicable command in one of the AWS SDKs.
     */
    public String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueryLoggingConfigRequest)) {
            return false;
        }
        CreateQueryLoggingConfigRequest other = (CreateQueryLoggingConfigRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateQueryLoggingConfigRequest").add("HostedZoneId", hostedZoneId())
                .add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "CloudWatchLogsLogGroupArn":
            return Optional.of(clazz.cast(cloudWatchLogsLogGroupArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, CreateQueryLoggingConfigRequest> {
        /**
         * <p>
         * The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted
         *        zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This
         * is the format of the ARN:
         * </p>
         * <p>
         * arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
         * </p>
         * <p>
         * To get the ARN for a log group, you can use the CloudWatch console, the <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
         * >DescribeLogGroups</a> API action, the <a
         * href="http://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a>
         * command, or the applicable command in one of the AWS SDKs.
         * </p>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs
         *        to. This is the format of the ARN:</p>
         *        <p>
         *        arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
         *        </p>
         *        <p>
         *        To get the ARN for a log group, you can use the CloudWatch console, the <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html"
         *        >DescribeLogGroups</a> API action, the <a
         *        href="http://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html"
         *        >describe-log-groups</a> command, or the applicable command in one of the AWS SDKs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private String cloudWatchLogsLogGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueryLoggingConfigRequest model) {
            hostedZoneId(model.hostedZoneId);
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateQueryLoggingConfigRequest build() {
            return new CreateQueryLoggingConfigRequest(this);
        }
    }
}
