/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheck</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHealthCheckResponse extends Route53Response implements
        ToCopyableBuilder<GetHealthCheckResponse.Builder, GetHealthCheckResponse> {
    private final HealthCheck healthCheck;

    private GetHealthCheckResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheck = builder.healthCheck;
    }

    /**
     * <p>
     * A complex type that contains information about one health check that is associated with the current AWS account.
     * </p>
     * 
     * @return A complex type that contains information about one health check that is associated with the current AWS
     *         account.
     */
    public HealthCheck healthCheck() {
        return healthCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheck());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckResponse)) {
            return false;
        }
        GetHealthCheckResponse other = (GetHealthCheckResponse) obj;
        return Objects.equals(healthCheck(), other.healthCheck());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHealthCheckResponse").add("HealthCheck", healthCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheck":
            return Optional.of(clazz.cast(healthCheck()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, GetHealthCheckResponse> {
        /**
         * <p>
         * A complex type that contains information about one health check that is associated with the current AWS
         * account.
         * </p>
         * 
         * @param healthCheck
         *        A complex type that contains information about one health check that is associated with the current
         *        AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheck(HealthCheck healthCheck);

        /**
         * <p>
         * A complex type that contains information about one health check that is associated with the current AWS
         * account.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheck.Builder} avoiding the need to create
         * one manually via {@link HealthCheck#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheck.Builder#build()} is called immediately and its result
         * is passed to {@link #healthCheck(HealthCheck)}.
         * 
         * @param healthCheck
         *        a consumer that will call methods on {@link HealthCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheck(HealthCheck)
         */
        default Builder healthCheck(Consumer<HealthCheck.Builder> healthCheck) {
            return healthCheck(HealthCheck.builder().apply(healthCheck).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private HealthCheck healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckResponse model) {
            healthCheck(model.healthCheck);
        }

        public final HealthCheck.Builder getHealthCheck() {
            return healthCheck != null ? healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public GetHealthCheckResponse build() {
            return new GetHealthCheckResponse(this);
        }
    }
}
