/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to create a hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetReusableDelegationSetLimitRequest extends Route53Request implements
        ToCopyableBuilder<GetReusableDelegationSetLimitRequest.Builder, GetReusableDelegationSetLimitRequest> {
    private final String type;

    private final String delegationSetId;

    private GetReusableDelegationSetLimitRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.delegationSetId = builder.delegationSetId;
    }

    /**
     * <p>
     * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can
     * associate with the specified reusable delegation set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReusableDelegationSetLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeString}.
     * </p>
     * 
     * @return Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that
     *         you can associate with the specified reusable delegation set.
     * @see ReusableDelegationSetLimitType
     */
    public ReusableDelegationSetLimitType type() {
        return ReusableDelegationSetLimitType.fromValue(type);
    }

    /**
     * <p>
     * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can
     * associate with the specified reusable delegation set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReusableDelegationSetLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeString}.
     * </p>
     * 
     * @return Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that
     *         you can associate with the specified reusable delegation set.
     * @see ReusableDelegationSetLimitType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The ID of the delegation set that you want to get the limit for.
     * </p>
     * 
     * @return The ID of the delegation set that you want to get the limit for.
     */
    public String delegationSetId() {
        return delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetLimitRequest)) {
            return false;
        }
        GetReusableDelegationSetLimitRequest other = (GetReusableDelegationSetLimitRequest) obj;
        return Objects.equals(typeString(), other.typeString()) && Objects.equals(delegationSetId(), other.delegationSetId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetReusableDelegationSetLimitRequest").add("Type", typeString())
                .add("DelegationSetId", delegationSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "DelegationSetId":
            return Optional.of(clazz.cast(delegationSetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, GetReusableDelegationSetLimitRequest> {
        /**
         * <p>
         * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you
         * can associate with the specified reusable delegation set.
         * </p>
         * 
         * @param type
         *        Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones
         *        that you can associate with the specified reusable delegation set.
         * @see ReusableDelegationSetLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReusableDelegationSetLimitType
         */
        Builder type(String type);

        /**
         * <p>
         * Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you
         * can associate with the specified reusable delegation set.
         * </p>
         * 
         * @param type
         *        Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones
         *        that you can associate with the specified reusable delegation set.
         * @see ReusableDelegationSetLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReusableDelegationSetLimitType
         */
        Builder type(ReusableDelegationSetLimitType type);

        /**
         * <p>
         * The ID of the delegation set that you want to get the limit for.
         * </p>
         * 
         * @param delegationSetId
         *        The ID of the delegation set that you want to get the limit for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSetId(String delegationSetId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String type;

        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetLimitRequest model) {
            type(model.type);
            delegationSetId(model.delegationSetId);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReusableDelegationSetLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDelegationSetId() {
            return delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetReusableDelegationSetLimitRequest build() {
            return new GetReusableDelegationSetLimitRequest(this);
        }
    }
}
