/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the type of limit that you specified in the request and the current value for that
 * limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HostedZoneLimit implements ToCopyableBuilder<HostedZoneLimit.Builder, HostedZoneLimit> {
    private final String type;

    private final Long value;

    private HostedZoneLimit(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The limit that you requested. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the specified
     * private hosted zone.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HostedZoneLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The limit that you requested. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
     *         zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
     *         specified private hosted zone.
     *         </p>
     *         </li>
     * @see HostedZoneLimitType
     */
    public HostedZoneLimitType type() {
        return HostedZoneLimitType.fromValue(type);
    }

    /**
     * <p>
     * The limit that you requested. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the specified
     * private hosted zone.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HostedZoneLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The limit that you requested. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
     *         zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
     *         specified private hosted zone.
     *         </p>
     *         </li>
     * @see HostedZoneLimitType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The current value for the limit that is specified by <code>Type</code>.
     * </p>
     * 
     * @return The current value for the limit that is specified by <code>Type</code>.
     */
    public Long value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneLimit)) {
            return false;
        }
        HostedZoneLimit other = (HostedZoneLimit) obj;
        return Objects.equals(typeString(), other.typeString()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("HostedZoneLimit").add("Type", typeString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HostedZoneLimit> {
        /**
         * <p>
         * The limit that you requested. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         * specified private hosted zone.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The limit that you requested. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
         *        zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         *        specified private hosted zone.
         *        </p>
         *        </li>
         * @see HostedZoneLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostedZoneLimitType
         */
        Builder type(String type);

        /**
         * <p>
         * The limit that you requested. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         * specified private hosted zone.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The limit that you requested. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
         *        zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         *        specified private hosted zone.
         *        </p>
         *        </li>
         * @see HostedZoneLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostedZoneLimitType
         */
        Builder type(HostedZoneLimitType type);

        /**
         * <p>
         * The current value for the limit that is specified by <code>Type</code>.
         * </p>
         * 
         * @param value
         *        The current value for the limit that is specified by <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Long value;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneLimit model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HostedZoneLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getValue() {
            return value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public HostedZoneLimit build() {
            return new HostedZoneLimit(this);
        }
    }
}
