/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If a health check or hosted zone was created by another service, <code>LinkedService</code> is a complex type that
 * describes the service that created the resource. When a resource is created by another service, you can't edit or
 * delete it using Amazon Route 53.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LinkedService implements ToCopyableBuilder<LinkedService.Builder, LinkedService> {
    private final String servicePrincipal;

    private final String description;

    private LinkedService(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.description = builder.description;
    }

    /**
     * <p>
     * If the health check or hosted zone was created by another service, the service that created the resource. When a
     * resource is created by another service, you can't edit or delete it using Amazon Route 53.
     * </p>
     * 
     * @return If the health check or hosted zone was created by another service, the service that created the resource.
     *         When a resource is created by another service, you can't edit or delete it using Amazon Route 53.
     */
    public String servicePrincipal() {
        return servicePrincipal;
    }

    /**
     * <p>
     * If the health check or hosted zone was created by another service, an optional description that can be provided
     * by the other service. When a resource is created by another service, you can't edit or delete it using Amazon
     * Route 53.
     * </p>
     * 
     * @return If the health check or hosted zone was created by another service, an optional description that can be
     *         provided by the other service. When a resource is created by another service, you can't edit or delete it
     *         using Amazon Route 53.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedService)) {
            return false;
        }
        LinkedService other = (LinkedService) obj;
        return Objects.equals(servicePrincipal(), other.servicePrincipal()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("LinkedService").add("ServicePrincipal", servicePrincipal()).add("Description", description())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServicePrincipal":
            return Optional.of(clazz.cast(servicePrincipal()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LinkedService> {
        /**
         * <p>
         * If the health check or hosted zone was created by another service, the service that created the resource.
         * When a resource is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * 
         * @param servicePrincipal
         *        If the health check or hosted zone was created by another service, the service that created the
         *        resource. When a resource is created by another service, you can't edit or delete it using Amazon
         *        Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        /**
         * <p>
         * If the health check or hosted zone was created by another service, an optional description that can be
         * provided by the other service. When a resource is created by another service, you can't edit or delete it
         * using Amazon Route 53.
         * </p>
         * 
         * @param description
         *        If the health check or hosted zone was created by another service, an optional description that can be
         *        provided by the other service. When a resource is created by another service, you can't edit or delete
         *        it using Amazon Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String servicePrincipal;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedService model) {
            servicePrincipal(model.servicePrincipal);
            description(model.description);
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public LinkedService build() {
            return new LinkedService(this);
        }
    }
}
