/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListHostedZonesByNameResponse extends Route53Response implements
        ToCopyableBuilder<ListHostedZonesByNameResponse.Builder, ListHostedZonesByNameResponse> {
    private final List<HostedZone> hostedZones;

    private final String dnsName;

    private final String hostedZoneId;

    private final Boolean isTruncated;

    private final String nextDNSName;

    private final String nextHostedZoneId;

    private final String maxItems;

    private ListHostedZonesByNameResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZones = builder.hostedZones;
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.isTruncated = builder.isTruncated;
        this.nextDNSName = builder.nextDNSName;
        this.nextHostedZoneId = builder.nextHostedZoneId;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A complex type that contains general information about the hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains general information about the hosted zone.
     */
    public List<HostedZone> hostedZones() {
        return hostedZones;
    }

    /**
     * <p>
     * For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that
     * you specified for the <code>dnsname</code> parameter in the request that produced the current response.
     * </p>
     * 
     * @return For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the
     *         value that you specified for the <code>dnsname</code> parameter in the request that produced the current
     *         response.
     */
    public String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can
     * get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and
     * specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the
     * <code>dnsname</code> and <code>hostedzoneid</code> parameters.
     * </p>
     * 
     * @return A flag that indicates whether there are more hosted zones to be listed. If the response was truncated,
     *         you can get the next group of <code>maxitems</code> hosted zones by calling
     *         <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and
     *         <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code>
     *         parameters.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone
     * in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and
     * specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is <code>true</code>.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first
     *         hosted zone in the next group of <code>maxitems</code> hosted zones. Call
     *         <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
     *         <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
     *         respectively.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is <code>true</code>.
     */
    public String nextDNSName() {
        return nextDNSName;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first
     * hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code>
     * again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the
     * <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is <code>true</code>.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies
     *         the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call
     *         <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
     *         <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
     *         respectively.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is <code>true</code>.
     */
    public String nextHostedZoneId() {
        return nextHostedZoneId;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the call to
     * <code>ListHostedZonesByName</code> that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the call to
     *         <code>ListHostedZonesByName</code> that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZones());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(nextHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameResponse)) {
            return false;
        }
        ListHostedZonesByNameResponse other = (ListHostedZonesByNameResponse) obj;
        return Objects.equals(hostedZones(), other.hostedZones()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(nextDNSName(), other.nextDNSName())
                && Objects.equals(nextHostedZoneId(), other.nextHostedZoneId()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListHostedZonesByNameResponse").add("HostedZones", hostedZones()).add("DNSName", dnsName())
                .add("HostedZoneId", hostedZoneId()).add("IsTruncated", isTruncated()).add("NextDNSName", nextDNSName())
                .add("NextHostedZoneId", nextHostedZoneId()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZones":
            return Optional.of(clazz.cast(hostedZones()));
        case "DNSName":
            return Optional.of(clazz.cast(dnsName()));
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "NextDNSName":
            return Optional.of(clazz.cast(nextDNSName()));
        case "NextHostedZoneId":
            return Optional.of(clazz.cast(nextHostedZoneId()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ListHostedZonesByNameResponse> {
        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(Collection<HostedZone> hostedZones);

        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(HostedZone... hostedZones);

        /**
         * <p>
         * For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value
         * that you specified for the <code>dnsname</code> parameter in the request that produced the current response.
         * </p>
         * 
         * @param dnsName
         *        For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the
         *        value that you specified for the <code>dnsname</code> parameter in the request that produced the
         *        current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you
         * can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code>
         * again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the
         * <code>dnsname</code> and <code>hostedzoneid</code> parameters.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more hosted zones to be listed. If the response was truncated,
         *        you can get the next group of <code>maxitems</code> hosted zones by calling
         *        <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and
         *        <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code>
         *        parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted
         * zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again
         * and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the
         * <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * </p>
         * 
         * @param nextDNSName
         *        If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first
         *        hosted zone in the next group of <code>maxitems</code> hosted zones. Call
         *        <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
         *        <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
         *        respectively.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextDNSName(String nextDNSName);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the
         * first hosted zone in the next group of <code>maxitems</code> hosted zones. Call
         * <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
         * <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
         * respectively.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * </p>
         * 
         * @param nextHostedZoneId
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code>
         *        identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call
         *        <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
         *        <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
         *        respectively.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextHostedZoneId(String nextHostedZoneId);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the call to
         * <code>ListHostedZonesByName</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the call to
         *        <code>ListHostedZonesByName</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HostedZone> hostedZones;

        private String dnsName;

        private String hostedZoneId;

        private Boolean isTruncated;

        private String nextDNSName;

        private String nextHostedZoneId;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameResponse model) {
            hostedZones(model.hostedZones);
            dnsName(model.dnsName);
            hostedZoneId(model.hostedZoneId);
            isTruncated(model.isTruncated);
            nextDNSName(model.nextDNSName);
            nextHostedZoneId(model.nextHostedZoneId);
            maxItems(model.maxItems);
        }

        public final Collection<HostedZone.Builder> getHostedZones() {
            return hostedZones != null ? hostedZones.stream().map(HostedZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone... hostedZones) {
            hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        public final void setHostedZones(Collection<HostedZone.BuilderImpl> hostedZones) {
            this.hostedZones = HostedZonesCopier.copyFromBuilder(hostedZones);
        }

        public final String getDNSName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextDNSName() {
            return nextDNSName;
        }

        @Override
        public final Builder nextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
            return this;
        }

        public final void setNextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
        }

        public final String getNextHostedZoneId() {
            return nextHostedZoneId;
        }

        @Override
        public final Builder nextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
            return this;
        }

        public final void setNextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHostedZonesByNameResponse build() {
            return new ListHostedZonesByNameResponse(this);
        }
    }
}
