/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListHealthChecksResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListHealthChecksResponseUnmarshaller implements Unmarshaller<ListHealthChecksResponse, StaxUnmarshallerContext> {

    public ListHealthChecksResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListHealthChecksResponse.Builder listHealthChecksResponse = ListHealthChecksResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<HealthCheck> healthChecks = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listHealthChecksResponse.healthChecks(healthChecks);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("HealthChecks", targetDepth)) {
                    healthChecks = new ArrayList<HealthCheck>();
                    continue;
                }

                if (context.testExpression("HealthChecks/HealthCheck", targetDepth)) {
                    healthChecks.add(HealthCheckUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Marker", targetDepth)) {
                    listHealthChecksResponse.marker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listHealthChecksResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextMarker", targetDepth)) {
                    listHealthChecksResponse.nextMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listHealthChecksResponse.maxItems(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listHealthChecksResponse.healthChecks(healthChecks);
                    break;
                }
            }
        }
        return listHealthChecksResponse.build();
    }

    private static final ListHealthChecksResponseUnmarshaller INSTANCE = new ListHealthChecksResponseUnmarshaller();

    public static ListHealthChecksResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
