/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GetOperationDetail response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOperationDetailResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<GetOperationDetailResponse.Builder, GetOperationDetailResponse> {
    private final String operationId;

    private final String status;

    private final String message;

    private final String domainName;

    private final String type;

    private final Instant submittedDate;

    private GetOperationDetailResponse(BuilderImpl builder) {
        super(builder);
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.message = builder.message;
        this.domainName = builder.domainName;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    /**
     * <p>
     * The identifier for the operation.
     * </p>
     * 
     * @return The identifier for the operation.
     */
    public String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * Detailed information on the status including possible errors.
     * </p>
     * 
     * @return Detailed information on the status including possible errors.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The name of a domain.
     * </p>
     * 
     * @return The name of a domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The type of operation that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of operation that was requested.
     * @see OperationType
     */
    public OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * The type of operation that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of operation that was requested.
     * @see OperationType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The date when the request was submitted.
     * </p>
     * 
     * @return The date when the request was submitted.
     */
    public Instant submittedDate() {
        return submittedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationDetailResponse)) {
            return false;
        }
        GetOperationDetailResponse other = (GetOperationDetailResponse) obj;
        return Objects.equals(operationId(), other.operationId()) && Objects.equals(statusString(), other.statusString())
                && Objects.equals(message(), other.message()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(typeString(), other.typeString()) && Objects.equals(submittedDate(), other.submittedDate());
    }

    @Override
    public String toString() {
        return ToString.builder("GetOperationDetailResponse").add("OperationId", operationId()).add("Status", statusString())
                .add("Message", message()).add("DomainName", domainName()).add("Type", typeString())
                .add("SubmittedDate", submittedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "SubmittedDate":
            return Optional.of(clazz.cast(submittedDate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsResponse.Builder, CopyableBuilder<Builder, GetOperationDetailResponse> {
        /**
         * <p>
         * The identifier for the operation.
         * </p>
         * 
         * @param operationId
         *        The identifier for the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * Detailed information on the status including possible errors.
         * </p>
         * 
         * @param message
         *        Detailed information on the status including possible errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The name of a domain.
         * </p>
         * 
         * @param domainName
         *        The name of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The type of operation that was requested.
         * </p>
         * 
         * @param type
         *        The type of operation that was requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of operation that was requested.
         * </p>
         * 
         * @param type
         *        The type of operation that was requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The date when the request was submitted.
         * </p>
         * 
         * @param submittedDate
         *        The date when the request was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedDate(Instant submittedDate);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String operationId;

        private String status;

        private String message;

        private String domainName;

        private String type;

        private Instant submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationDetailResponse model) {
            operationId(model.operationId);
            status(model.status);
            message(model.message);
            domainName(model.domainName);
            type(model.type);
            submittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getSubmittedDate() {
            return submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        @Override
        public GetOperationDetailResponse build() {
            return new GetOperationDetailResponse(this);
        }
    }
}
