/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListOperations request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListOperationsRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<ListOperationsRequest.Builder, ListOperationsRequest> {
    private final String marker;

    private final Integer maxItems;

    private ListOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * For an initial request for a list of operations, omit this element. If the number of operations that are not yet
     * complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code>
     * to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and
     * submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
     * </p>
     * 
     * @return For an initial request for a list of operations, omit this element. If the number of operations that are
     *         not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use
     *         <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from
     *         the previous response, and submit another request that includes the value of <code>NextPageMarker</code>
     *         in the <code>Marker</code> element.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Number of domains to be returned.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return Number of domains to be returned.</p>
     *         <p>
     *         Default: 20
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsRequest)) {
            return false;
        }
        ListOperationsRequest other = (ListOperationsRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListOperationsRequest").add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, ListOperationsRequest> {
        /**
         * <p>
         * For an initial request for a list of operations, omit this element. If the number of operations that are not
         * yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use
         * <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the
         * previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the
         * <code>Marker</code> element.
         * </p>
         * 
         * @param marker
         *        For an initial request for a list of operations, omit this element. If the number of operations that
         *        are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can
         *        use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code>
         *        from the previous response, and submit another request that includes the value of
         *        <code>NextPageMarker</code> in the <code>Marker</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Number of domains to be returned.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxItems
         *        Number of domains to be returned.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsRequest model) {
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListOperationsRequest build() {
            return new ListOperationsRequest(this);
        }
    }
}
