/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ResendContactReachabilityEmailRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<ResendContactReachabilityEmailRequest.Builder, ResendContactReachabilityEmailRequest> {
    private final String domainName;

    private ResendContactReachabilityEmailRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * The name of the domain for which you want Amazon Route 53 to resend a confirmation email to the registrant
     * contact.
     * </p>
     * 
     * @return The name of the domain for which you want Amazon Route 53 to resend a confirmation email to the
     *         registrant contact.
     */
    public String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResendContactReachabilityEmailRequest)) {
            return false;
        }
        ResendContactReachabilityEmailRequest other = (ResendContactReachabilityEmailRequest) obj;
        return Objects.equals(domainName(), other.domainName());
    }

    @Override
    public String toString() {
        return ToString.builder("ResendContactReachabilityEmailRequest").add("DomainName", domainName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.of(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder,
            CopyableBuilder<Builder, ResendContactReachabilityEmailRequest> {
        /**
         * <p>
         * The name of the domain for which you want Amazon Route 53 to resend a confirmation email to the registrant
         * contact.
         * </p>
         * 
         * @param domainName
         *        The name of the domain for which you want Amazon Route 53 to resend a confirmation email to the
         *        registrant contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(ResendContactReachabilityEmailRequest model) {
            domainName(model.domainName);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResendContactReachabilityEmailRequest build() {
            return new ResendContactReachabilityEmailRequest(this);
        }
    }
}
