/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateDomainContact request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDomainContactRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<UpdateDomainContactRequest.Builder, UpdateDomainContactRequest> {
    private final String domainName;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private UpdateDomainContactRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
    }

    /**
     * <p>
     * The name of the domain that you want to update contact information for.
     * </p>
     * 
     * @return The name of the domain that you want to update contact information for.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail techContact() {
        return techContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(techContact());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactRequest)) {
            return false;
        }
        UpdateDomainContactRequest other = (UpdateDomainContactRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(adminContact(), other.adminContact())
                && Objects.equals(registrantContact(), other.registrantContact())
                && Objects.equals(techContact(), other.techContact());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDomainContactRequest").add("DomainName", domainName()).add("AdminContact", adminContact())
                .add("RegistrantContact", registrantContact()).add("TechContact", techContact()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "AdminContact":
            return Optional.of(clazz.cast(adminContact()));
        case "RegistrantContact":
            return Optional.of(clazz.cast(registrantContact()));
        case "TechContact":
            return Optional.of(clazz.cast(techContact()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, UpdateDomainContactRequest> {
        /**
         * <p>
         * The name of the domain that you want to update contact information for.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to update contact information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param adminContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #adminContact(ContactDetail)}.
         * 
         * @param adminContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminContact(ContactDetail)
         */
        default Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return adminContact(ContactDetail.builder().apply(adminContact).build());
        }

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param registrantContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #registrantContact(ContactDetail)}.
         * 
         * @param registrantContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrantContact(ContactDetail)
         */
        default Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return registrantContact(ContactDetail.builder().apply(registrantContact).build());
        }

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param techContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #techContact(ContactDetail)}.
         * 
         * @param techContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #techContact(ContactDetail)
         */
        default Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return techContact(ContactDetail.builder().apply(techContact).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactRequest model) {
            domainName(model.domainName);
            adminContact(model.adminContact);
            registrantContact(model.registrantContact);
            techContact(model.techContact);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ContactDetail.Builder getAdminContact() {
            return adminContact != null ? adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return registrantContact != null ? registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return techContact != null ? techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainContactRequest build() {
            return new UpdateDomainContactRequest(this);
        }
    }
}
