/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.route53domains.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ContactDetail JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ContactDetailUnmarshaller implements Unmarshaller<ContactDetail, JsonUnmarshallerContext> {

    public ContactDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        ContactDetail.Builder contactDetailBuilder = ContactDetail.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("FirstName", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.firstName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastName", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.lastName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ContactType", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.contactType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("OrganizationName", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.organizationName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AddressLine1", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.addressLine1(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AddressLine2", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.addressLine2(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("City", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.city(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.state(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CountryCode", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.countryCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ZipCode", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.zipCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PhoneNumber", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.phoneNumber(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Email", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.email(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Fax", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.fax(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExtraParams", targetDepth)) {
                    context.nextToken();
                    contactDetailBuilder.extraParams(new ListUnmarshaller<ExtraParam>(ExtraParamUnmarshaller.getInstance())
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return contactDetailBuilder.build();
    }

    private static final ContactDetailUnmarshaller INSTANCE = new ContactDetailUnmarshaller();

    public static ContactDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}
