/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.route53domains.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeleteTagsForDomainResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteTagsForDomainResponseUnmarshaller implements
        Unmarshaller<DeleteTagsForDomainResponse, JsonUnmarshallerContext> {

    public DeleteTagsForDomainResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeleteTagsForDomainResponse.Builder deleteTagsForDomainResponseBuilder = DeleteTagsForDomainResponse.builder();

        return deleteTagsForDomainResponseBuilder.build();
    }

    private static final DeleteTagsForDomainResponseUnmarshaller INSTANCE = new DeleteTagsForDomainResponseUnmarshaller();

    public static DeleteTagsForDomainResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
