/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeBatch
implements ToCopyableBuilder<Builder, ChangeBatch> {
    private final String comment;
    private final List<Change> changes;

    private ChangeBatch(BuilderImpl builder) {
        this.comment = builder.comment;
        this.changes = builder.changes;
    }

    public String comment() {
        return this.comment;
    }

    public List<Change> changes() {
        return this.changes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.changes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeBatch)) {
            return false;
        }
        ChangeBatch other = (ChangeBatch)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.changes(), other.changes());
    }

    public String toString() {
        return ToString.builder((String)"ChangeBatch").add("Comment", (Object)this.comment()).add("Changes", this.changes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "Changes": {
                return Optional.of(clazz.cast(this.changes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private List<Change> changes;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeBatch model) {
            this.comment(model.comment);
            this.changes(model.changes);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Collection<Change.Builder> getChanges() {
            return this.changes != null ? (Collection)this.changes.stream().map(Change::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangesCopier.copyFromBuilder(changes);
        }

        public ChangeBatch build() {
            return new ChangeBatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeBatch> {
        public Builder comment(String var1);

        public Builder changes(Collection<Change> var1);

        public Builder changes(Change ... var1);
    }
}

