/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration;
import software.amazon.awssdk.services.route53.model.HealthCheckConfig;
import software.amazon.awssdk.services.route53.model.LinkedService;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HealthCheck
implements ToCopyableBuilder<Builder, HealthCheck> {
    private final String id;
    private final String callerReference;
    private final LinkedService linkedService;
    private final HealthCheckConfig healthCheckConfig;
    private final Long healthCheckVersion;
    private final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

    private HealthCheck(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.linkedService = builder.linkedService;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckVersion = builder.healthCheckVersion;
        this.cloudWatchAlarmConfiguration = builder.cloudWatchAlarmConfiguration;
    }

    public String id() {
        return this.id;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public LinkedService linkedService() {
        return this.linkedService;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public Long healthCheckVersion() {
        return this.healthCheckVersion;
    }

    public CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration() {
        return this.cloudWatchAlarmConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedService());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchAlarmConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.linkedService(), other.linkedService()) && Objects.equals(this.healthCheckConfig(), other.healthCheckConfig()) && Objects.equals(this.healthCheckVersion(), other.healthCheckVersion()) && Objects.equals(this.cloudWatchAlarmConfiguration(), other.cloudWatchAlarmConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"HealthCheck").add("Id", (Object)this.id()).add("CallerReference", (Object)this.callerReference()).add("LinkedService", (Object)this.linkedService()).add("HealthCheckConfig", (Object)this.healthCheckConfig()).add("HealthCheckVersion", (Object)this.healthCheckVersion()).add("CloudWatchAlarmConfiguration", (Object)this.cloudWatchAlarmConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "LinkedService": {
                return Optional.of(clazz.cast(this.linkedService()));
            }
            case "HealthCheckConfig": {
                return Optional.of(clazz.cast(this.healthCheckConfig()));
            }
            case "HealthCheckVersion": {
                return Optional.of(clazz.cast(this.healthCheckVersion()));
            }
            case "CloudWatchAlarmConfiguration": {
                return Optional.of(clazz.cast(this.cloudWatchAlarmConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String callerReference;
        private LinkedService linkedService;
        private HealthCheckConfig healthCheckConfig;
        private Long healthCheckVersion;
        private CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            this.id(model.id);
            this.callerReference(model.callerReference);
            this.linkedService(model.linkedService);
            this.healthCheckConfig(model.healthCheckConfig);
            this.healthCheckVersion(model.healthCheckVersion);
            this.cloudWatchAlarmConfiguration(model.cloudWatchAlarmConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final LinkedService.Builder getLinkedService() {
            return this.linkedService != null ? this.linkedService.toBuilder() : null;
        }

        @Override
        public final Builder linkedService(LinkedService linkedService) {
            this.linkedService = linkedService;
            return this;
        }

        public final void setLinkedService(LinkedService.BuilderImpl linkedService) {
            this.linkedService = linkedService != null ? linkedService.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final Long getHealthCheckVersion() {
            return this.healthCheckVersion;
        }

        @Override
        public final Builder healthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
            return this;
        }

        public final void setHealthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
        }

        public final CloudWatchAlarmConfiguration.Builder getCloudWatchAlarmConfiguration() {
            return this.cloudWatchAlarmConfiguration != null ? this.cloudWatchAlarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration;
            return this;
        }

        public final void setCloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration.BuilderImpl cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration != null ? cloudWatchAlarmConfiguration.build() : null;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheck> {
        public Builder id(String var1);

        public Builder callerReference(String var1);

        public Builder linkedService(LinkedService var1);

        default public Builder linkedService(Consumer<LinkedService.Builder> linkedService) {
            return this.linkedService((LinkedService)((LinkedService.Builder)LinkedService.builder().apply(linkedService)).build());
        }

        public Builder healthCheckConfig(HealthCheckConfig var1);

        default public Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return this.healthCheckConfig((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().apply(healthCheckConfig)).build());
        }

        public Builder healthCheckVersion(Long var1);

        public Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration var1);

        default public Builder cloudWatchAlarmConfiguration(Consumer<CloudWatchAlarmConfiguration.Builder> cloudWatchAlarmConfiguration) {
            return this.cloudWatchAlarmConfiguration((CloudWatchAlarmConfiguration)((CloudWatchAlarmConfiguration.Builder)CloudWatchAlarmConfiguration.builder().apply(cloudWatchAlarmConfiguration)).build());
        }
    }
}

