/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.route53.model.AlarmIdentifier;
import software.amazon.awssdk.services.route53.model.ChildHealthCheckListCopier;
import software.amazon.awssdk.services.route53.model.HealthCheckRegion;
import software.amazon.awssdk.services.route53.model.HealthCheckRegionListCopier;
import software.amazon.awssdk.services.route53.model.HealthCheckType;
import software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HealthCheckConfig
implements ToCopyableBuilder<Builder, HealthCheckConfig> {
    private final String ipAddress;
    private final Integer port;
    private final String type;
    private final String resourcePath;
    private final String fullyQualifiedDomainName;
    private final String searchString;
    private final Integer requestInterval;
    private final Integer failureThreshold;
    private final Boolean measureLatency;
    private final Boolean inverted;
    private final Integer healthThreshold;
    private final List<String> childHealthChecks;
    private final Boolean enableSNI;
    private final List<String> regions;
    private final AlarmIdentifier alarmIdentifier;
    private final String insufficientDataHealthStatus;

    private HealthCheckConfig(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.type = builder.type;
        this.resourcePath = builder.resourcePath;
        this.fullyQualifiedDomainName = builder.fullyQualifiedDomainName;
        this.searchString = builder.searchString;
        this.requestInterval = builder.requestInterval;
        this.failureThreshold = builder.failureThreshold;
        this.measureLatency = builder.measureLatency;
        this.inverted = builder.inverted;
        this.healthThreshold = builder.healthThreshold;
        this.childHealthChecks = builder.childHealthChecks;
        this.enableSNI = builder.enableSNI;
        this.regions = builder.regions;
        this.alarmIdentifier = builder.alarmIdentifier;
        this.insufficientDataHealthStatus = builder.insufficientDataHealthStatus;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public Integer port() {
        return this.port;
    }

    public HealthCheckType type() {
        return HealthCheckType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String resourcePath() {
        return this.resourcePath;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public String searchString() {
        return this.searchString;
    }

    public Integer requestInterval() {
        return this.requestInterval;
    }

    public Integer failureThreshold() {
        return this.failureThreshold;
    }

    public Boolean measureLatency() {
        return this.measureLatency;
    }

    public Boolean inverted() {
        return this.inverted;
    }

    public Integer healthThreshold() {
        return this.healthThreshold;
    }

    public List<String> childHealthChecks() {
        return this.childHealthChecks;
    }

    public Boolean enableSNI() {
        return this.enableSNI;
    }

    public List<HealthCheckRegion> regions() {
        return TypeConverter.convert(this.regions, HealthCheckRegion::fromValue);
    }

    public List<String> regionsStrings() {
        return this.regions;
    }

    public AlarmIdentifier alarmIdentifier() {
        return this.alarmIdentifier;
    }

    public InsufficientDataHealthStatus insufficientDataHealthStatus() {
        return InsufficientDataHealthStatus.fromValue(this.insufficientDataHealthStatus);
    }

    public String insufficientDataHealthStatusString() {
        return this.insufficientDataHealthStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.inverted());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.childHealthChecks());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSNI());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.insufficientDataHealthStatusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        return Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.resourcePath(), other.resourcePath()) && Objects.equals(this.fullyQualifiedDomainName(), other.fullyQualifiedDomainName()) && Objects.equals(this.searchString(), other.searchString()) && Objects.equals(this.requestInterval(), other.requestInterval()) && Objects.equals(this.failureThreshold(), other.failureThreshold()) && Objects.equals(this.measureLatency(), other.measureLatency()) && Objects.equals(this.inverted(), other.inverted()) && Objects.equals(this.healthThreshold(), other.healthThreshold()) && Objects.equals(this.childHealthChecks(), other.childHealthChecks()) && Objects.equals(this.enableSNI(), other.enableSNI()) && Objects.equals(this.regionsStrings(), other.regionsStrings()) && Objects.equals(this.alarmIdentifier(), other.alarmIdentifier()) && Objects.equals(this.insufficientDataHealthStatusString(), other.insufficientDataHealthStatusString());
    }

    public String toString() {
        return ToString.builder((String)"HealthCheckConfig").add("IPAddress", (Object)this.ipAddress()).add("Port", (Object)this.port()).add("Type", (Object)this.typeString()).add("ResourcePath", (Object)this.resourcePath()).add("FullyQualifiedDomainName", (Object)this.fullyQualifiedDomainName()).add("SearchString", (Object)this.searchString()).add("RequestInterval", (Object)this.requestInterval()).add("FailureThreshold", (Object)this.failureThreshold()).add("MeasureLatency", (Object)this.measureLatency()).add("Inverted", (Object)this.inverted()).add("HealthThreshold", (Object)this.healthThreshold()).add("ChildHealthChecks", this.childHealthChecks()).add("EnableSNI", (Object)this.enableSNI()).add("Regions", this.regionsStrings()).add("AlarmIdentifier", (Object)this.alarmIdentifier()).add("InsufficientDataHealthStatus", (Object)this.insufficientDataHealthStatusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "ResourcePath": {
                return Optional.of(clazz.cast(this.resourcePath()));
            }
            case "FullyQualifiedDomainName": {
                return Optional.of(clazz.cast(this.fullyQualifiedDomainName()));
            }
            case "SearchString": {
                return Optional.of(clazz.cast(this.searchString()));
            }
            case "RequestInterval": {
                return Optional.of(clazz.cast(this.requestInterval()));
            }
            case "FailureThreshold": {
                return Optional.of(clazz.cast(this.failureThreshold()));
            }
            case "MeasureLatency": {
                return Optional.of(clazz.cast(this.measureLatency()));
            }
            case "Inverted": {
                return Optional.of(clazz.cast(this.inverted()));
            }
            case "HealthThreshold": {
                return Optional.of(clazz.cast(this.healthThreshold()));
            }
            case "ChildHealthChecks": {
                return Optional.of(clazz.cast(this.childHealthChecks()));
            }
            case "EnableSNI": {
                return Optional.of(clazz.cast(this.enableSNI()));
            }
            case "Regions": {
                return Optional.of(clazz.cast(this.regionsStrings()));
            }
            case "AlarmIdentifier": {
                return Optional.of(clazz.cast(this.alarmIdentifier()));
            }
            case "InsufficientDataHealthStatus": {
                return Optional.of(clazz.cast(this.insufficientDataHealthStatusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ipAddress;
        private Integer port;
        private String type;
        private String resourcePath;
        private String fullyQualifiedDomainName;
        private String searchString;
        private Integer requestInterval;
        private Integer failureThreshold;
        private Boolean measureLatency;
        private Boolean inverted;
        private Integer healthThreshold;
        private List<String> childHealthChecks;
        private Boolean enableSNI;
        private List<String> regions;
        private AlarmIdentifier alarmIdentifier;
        private String insufficientDataHealthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            this.ipAddress(model.ipAddress);
            this.port(model.port);
            this.type(model.type);
            this.resourcePath(model.resourcePath);
            this.fullyQualifiedDomainName(model.fullyQualifiedDomainName);
            this.searchString(model.searchString);
            this.requestInterval(model.requestInterval);
            this.failureThreshold(model.failureThreshold);
            this.measureLatency(model.measureLatency);
            this.inverted(model.inverted);
            this.healthThreshold(model.healthThreshold);
            this.childHealthChecks(model.childHealthChecks);
            this.enableSNI(model.enableSNI);
            this.regions(model.regions);
            this.alarmIdentifier(model.alarmIdentifier);
            this.insufficientDataHealthStatus(model.insufficientDataHealthStatus);
        }

        public final String getIPAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIPAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HealthCheckType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public final String getFullyQualifiedDomainName() {
            return this.fullyQualifiedDomainName;
        }

        @Override
        public final Builder fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this;
        }

        public final void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        }

        public final String getSearchString() {
            return this.searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final Integer getRequestInterval() {
            return this.requestInterval;
        }

        @Override
        public final Builder requestInterval(Integer requestInterval) {
            this.requestInterval = requestInterval;
            return this;
        }

        public final void setRequestInterval(Integer requestInterval) {
            this.requestInterval = requestInterval;
        }

        public final Integer getFailureThreshold() {
            return this.failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        public final Boolean getMeasureLatency() {
            return this.measureLatency;
        }

        @Override
        public final Builder measureLatency(Boolean measureLatency) {
            this.measureLatency = measureLatency;
            return this;
        }

        public final void setMeasureLatency(Boolean measureLatency) {
            this.measureLatency = measureLatency;
        }

        public final Boolean getInverted() {
            return this.inverted;
        }

        @Override
        public final Builder inverted(Boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public final void setInverted(Boolean inverted) {
            this.inverted = inverted;
        }

        public final Integer getHealthThreshold() {
            return this.healthThreshold;
        }

        @Override
        public final Builder healthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
            return this;
        }

        public final void setHealthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
        }

        public final Collection<String> getChildHealthChecks() {
            return this.childHealthChecks;
        }

        @Override
        public final Builder childHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childHealthChecks(String ... childHealthChecks) {
            this.childHealthChecks(Arrays.asList(childHealthChecks));
            return this;
        }

        public final void setChildHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
        }

        public final Boolean getEnableSNI() {
            return this.enableSNI;
        }

        @Override
        public final Builder enableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
            return this;
        }

        public final void setEnableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
        }

        public final Collection<String> getRegions() {
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
        }

        public final AlarmIdentifier.Builder getAlarmIdentifier() {
            return this.alarmIdentifier != null ? this.alarmIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder alarmIdentifier(AlarmIdentifier alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
            return this;
        }

        public final void setAlarmIdentifier(AlarmIdentifier.BuilderImpl alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier != null ? alarmIdentifier.build() : null;
        }

        public final String getInsufficientDataHealthStatus() {
            return this.insufficientDataHealthStatus;
        }

        @Override
        public final Builder insufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
            return this;
        }

        @Override
        public final Builder insufficientDataHealthStatus(InsufficientDataHealthStatus insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus(insufficientDataHealthStatus.toString());
            return this;
        }

        public final void setInsufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
        }

        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheckConfig> {
        public Builder ipAddress(String var1);

        public Builder port(Integer var1);

        public Builder type(String var1);

        public Builder type(HealthCheckType var1);

        public Builder resourcePath(String var1);

        public Builder fullyQualifiedDomainName(String var1);

        public Builder searchString(String var1);

        public Builder requestInterval(Integer var1);

        public Builder failureThreshold(Integer var1);

        public Builder measureLatency(Boolean var1);

        public Builder inverted(Boolean var1);

        public Builder healthThreshold(Integer var1);

        public Builder childHealthChecks(Collection<String> var1);

        public Builder childHealthChecks(String ... var1);

        public Builder enableSNI(Boolean var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder alarmIdentifier(AlarmIdentifier var1);

        default public Builder alarmIdentifier(Consumer<AlarmIdentifier.Builder> alarmIdentifier) {
            return this.alarmIdentifier((AlarmIdentifier)((AlarmIdentifier.Builder)AlarmIdentifier.builder().apply(alarmIdentifier)).build());
        }

        public Builder insufficientDataHealthStatus(String var1);

        public Builder insufficientDataHealthStatus(InsufficientDataHealthStatus var1);
    }
}

