/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;

public class ListHealthChecksPublisher
implements SdkPublisher<ListHealthChecksResponse> {
    private final Route53AsyncClient client;
    private final ListHealthChecksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHealthChecksPublisher(Route53AsyncClient client, ListHealthChecksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHealthChecksPublisher(Route53AsyncClient client, ListHealthChecksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHealthChecksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHealthChecksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<HealthCheck> healthChecks() {
        Function<ListHealthChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthChecks() != null) {
                return response.healthChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListHealthChecksResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListHealthChecksPublisher resume(ListHealthChecksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListHealthChecksPublisher(this.client, (ListHealthChecksRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new ListHealthChecksPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListHealthChecksResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListHealthChecksResponseFetcher
    implements AsyncPageFetcher<ListHealthChecksResponse> {
        private ListHealthChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListHealthChecksResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListHealthChecksResponse> nextPage(ListHealthChecksResponse previousPage) {
            if (previousPage == null) {
                return ListHealthChecksPublisher.this.client.listHealthChecks(ListHealthChecksPublisher.this.firstRequest);
            }
            return ListHealthChecksPublisher.this.client.listHealthChecks((ListHealthChecksRequest)((Object)ListHealthChecksPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

