/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.ExtraParamName;
import software.amazon.awssdk.services.route53domains.transform.ExtraParamMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExtraParam
implements StructuredPojo,
ToCopyableBuilder<Builder, ExtraParam> {
    private final String name;
    private final String value;

    private ExtraParam(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    public ExtraParamName name() {
        return ExtraParamName.fromValue(this.name);
    }

    public String nameString() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtraParam)) {
            return false;
        }
        ExtraParam other = (ExtraParam)obj;
        return Objects.equals(this.nameString(), other.nameString()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"ExtraParam").add("Name", (Object)this.nameString()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.nameString()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtraParamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtraParam model) {
            this.name(model.name);
            this.value(model.value);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ExtraParamName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public ExtraParam build() {
            return new ExtraParam(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExtraParam> {
        public Builder name(String var1);

        public Builder name(ExtraParamName var1);

        public Builder value(String var1);
    }
}

