/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, RegisterDomainRequest> {
    private final String domainName;
    private final String idnLangCode;
    private final Integer durationInYears;
    private final Boolean autoRenew;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;
    private final Boolean privacyProtectAdminContact;
    private final Boolean privacyProtectRegistrantContact;
    private final Boolean privacyProtectTechContact;

    private RegisterDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
        this.durationInYears = builder.durationInYears;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.privacyProtectAdminContact = builder.privacyProtectAdminContact;
        this.privacyProtectRegistrantContact = builder.privacyProtectRegistrantContact;
        this.privacyProtectTechContact = builder.privacyProtectTechContact;
    }

    public String domainName() {
        return this.domainName;
    }

    public String idnLangCode() {
        return this.idnLangCode;
    }

    public Integer durationInYears() {
        return this.durationInYears;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public ContactDetail adminContact() {
        return this.adminContact;
    }

    public ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public ContactDetail techContact() {
        return this.techContact;
    }

    public Boolean privacyProtectAdminContact() {
        return this.privacyProtectAdminContact;
    }

    public Boolean privacyProtectRegistrantContact() {
        return this.privacyProtectRegistrantContact;
    }

    public Boolean privacyProtectTechContact() {
        return this.privacyProtectTechContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.idnLangCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.techContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectAdminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectRegistrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyProtectTechContact());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.idnLangCode(), other.idnLangCode()) && Objects.equals(this.durationInYears(), other.durationInYears()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.adminContact(), other.adminContact()) && Objects.equals(this.registrantContact(), other.registrantContact()) && Objects.equals(this.techContact(), other.techContact()) && Objects.equals(this.privacyProtectAdminContact(), other.privacyProtectAdminContact()) && Objects.equals(this.privacyProtectRegistrantContact(), other.privacyProtectRegistrantContact()) && Objects.equals(this.privacyProtectTechContact(), other.privacyProtectTechContact());
    }

    public String toString() {
        return ToString.builder((String)"RegisterDomainRequest").add("DomainName", (Object)this.domainName()).add("IdnLangCode", (Object)this.idnLangCode()).add("DurationInYears", (Object)this.durationInYears()).add("AutoRenew", (Object)this.autoRenew()).add("AdminContact", (Object)this.adminContact()).add("RegistrantContact", (Object)this.registrantContact()).add("TechContact", (Object)this.techContact()).add("PrivacyProtectAdminContact", (Object)this.privacyProtectAdminContact()).add("PrivacyProtectRegistrantContact", (Object)this.privacyProtectRegistrantContact()).add("PrivacyProtectTechContact", (Object)this.privacyProtectTechContact()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "IdnLangCode": {
                return Optional.of(clazz.cast(this.idnLangCode()));
            }
            case "DurationInYears": {
                return Optional.of(clazz.cast(this.durationInYears()));
            }
            case "AutoRenew": {
                return Optional.of(clazz.cast(this.autoRenew()));
            }
            case "AdminContact": {
                return Optional.of(clazz.cast(this.adminContact()));
            }
            case "RegistrantContact": {
                return Optional.of(clazz.cast(this.registrantContact()));
            }
            case "TechContact": {
                return Optional.of(clazz.cast(this.techContact()));
            }
            case "PrivacyProtectAdminContact": {
                return Optional.of(clazz.cast(this.privacyProtectAdminContact()));
            }
            case "PrivacyProtectRegistrantContact": {
                return Optional.of(clazz.cast(this.privacyProtectRegistrantContact()));
            }
            case "PrivacyProtectTechContact": {
                return Optional.of(clazz.cast(this.privacyProtectTechContact()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String idnLangCode;
        private Integer durationInYears;
        private Boolean autoRenew;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;
        private Boolean privacyProtectAdminContact;
        private Boolean privacyProtectRegistrantContact;
        private Boolean privacyProtectTechContact;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            this.domainName(model.domainName);
            this.idnLangCode(model.idnLangCode);
            this.durationInYears(model.durationInYears);
            this.autoRenew(model.autoRenew);
            this.adminContact(model.adminContact);
            this.registrantContact(model.registrantContact);
            this.techContact(model.techContact);
            this.privacyProtectAdminContact(model.privacyProtectAdminContact);
            this.privacyProtectRegistrantContact(model.privacyProtectRegistrantContact);
            this.privacyProtectTechContact(model.privacyProtectTechContact);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return this.idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        public final Integer getDurationInYears() {
            return this.durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail.Builder getAdminContact() {
            return this.adminContact != null ? this.adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return this.registrantContact != null ? this.registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return this.techContact != null ? this.techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        public final Boolean getPrivacyProtectAdminContact() {
            return this.privacyProtectAdminContact;
        }

        @Override
        public final Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
            return this;
        }

        public final void setPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
        }

        public final Boolean getPrivacyProtectRegistrantContact() {
            return this.privacyProtectRegistrantContact;
        }

        @Override
        public final Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
            return this;
        }

        public final void setPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
        }

        public final Boolean getPrivacyProtectTechContact() {
            return this.privacyProtectTechContact;
        }

        @Override
        public final Builder privacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
            return this;
        }

        public final void setPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    CopyableBuilder<Builder, RegisterDomainRequest> {
        public Builder domainName(String var1);

        public Builder idnLangCode(String var1);

        public Builder durationInYears(Integer var1);

        public Builder autoRenew(Boolean var1);

        public Builder adminContact(ContactDetail var1);

        default public Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return this.adminContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().apply(adminContact)).build());
        }

        public Builder registrantContact(ContactDetail var1);

        default public Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return this.registrantContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().apply(registrantContact)).build());
        }

        public Builder techContact(ContactDetail var1);

        default public Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return this.techContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().apply(techContact)).build());
        }

        public Builder privacyProtectAdminContact(Boolean var1);

        public Builder privacyProtectRegistrantContact(Boolean var1);

        public Builder privacyProtectTechContact(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

