/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.OperationSummary;

public class ListOperationsIterable
implements SdkIterable<ListOperationsResponse> {
    private final Route53DomainsClient client;
    private final ListOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOperationsIterable(Route53DomainsClient client, ListOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public Iterator<ListOperationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<OperationSummary> operations() {
        Function<ListOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.operations() != null) {
                return response.operations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListOperationsIterable resume(ListOperationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOperationsIterable(this.client, (ListOperationsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextPageMarker()).build()));
        }
        return new ListOperationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListOperationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListOperationsResponseFetcher
    implements SyncPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return previousPage.nextPageMarker() != null;
        }

        public ListOperationsResponse nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsIterable.this.client.listOperations(ListOperationsIterable.this.firstRequest);
            }
            return ListOperationsIterable.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsIterable.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

