/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.route53domains.Route53DomainsAsyncClient;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.OperationSummary;

public class ListOperationsPublisher
implements SdkPublisher<ListOperationsResponse> {
    private final Route53DomainsAsyncClient client;
    private final ListOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOperationsPublisher(Route53DomainsAsyncClient client, ListOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOperationsPublisher(Route53DomainsAsyncClient client, ListOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<OperationSummary> operations() {
        Function<ListOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.operations() != null) {
                return response.operations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListOperationsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListOperationsPublisher resume(ListOperationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOperationsPublisher(this.client, (ListOperationsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextPageMarker()).build()));
        }
        return new ListOperationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListOperationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListOperationsResponseFetcher
    implements AsyncPageFetcher<ListOperationsResponse> {
        private ListOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationsResponse previousPage) {
            return previousPage.nextPageMarker() != null;
        }

        public CompletableFuture<ListOperationsResponse> nextPage(ListOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationsPublisher.this.client.listOperations(ListOperationsPublisher.this.firstRequest);
            }
            return ListOperationsPublisher.this.client.listOperations((ListOperationsRequest)((Object)ListOperationsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

