/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ContactDetailMarshaller {
    private static final MarshallingInfo<String> FIRSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstName").isBinary(false).build();
    private static final MarshallingInfo<String> LASTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastName").isBinary(false).build();
    private static final MarshallingInfo<String> CONTACTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactType").isBinary(false).build();
    private static final MarshallingInfo<String> ORGANIZATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationName").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSLINE1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine1").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSLINE2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine2").isBinary(false).build();
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> COUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountryCode").isBinary(false).build();
    private static final MarshallingInfo<String> ZIPCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipCode").isBinary(false).build();
    private static final MarshallingInfo<String> PHONENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumber").isBinary(false).build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").isBinary(false).build();
    private static final MarshallingInfo<String> FAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Fax").isBinary(false).build();
    private static final MarshallingInfo<List> EXTRAPARAMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraParams").isBinary(false).build();
    private static final ContactDetailMarshaller INSTANCE = new ContactDetailMarshaller();

    private ContactDetailMarshaller() {
    }

    public static ContactDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContactDetail contactDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)contactDetail, (String)"contactDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)contactDetail.firstName(), FIRSTNAME_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.lastName(), LASTNAME_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.contactTypeString(), CONTACTTYPE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.organizationName(), ORGANIZATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.addressLine1(), ADDRESSLINE1_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.addressLine2(), ADDRESSLINE2_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.city(), CITY_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.countryCodeString(), COUNTRYCODE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.zipCode(), ZIPCODE_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.phoneNumber(), PHONENUMBER_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.email(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)contactDetail.fax(), FAX_BINDING);
            protocolMarshaller.marshall(contactDetail.extraParams(), EXTRAPARAMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

