/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.DomainSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainSummaryMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AUTORENEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoRenew").isBinary(false).build();
    private static final MarshallingInfo<Boolean> TRANSFERLOCK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TransferLock").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expiry").isBinary(false).build();
    private static final DomainSummaryMarshaller INSTANCE = new DomainSummaryMarshaller();

    private DomainSummaryMarshaller() {
    }

    public static DomainSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainSummary domainSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainSummary, (String)"domainSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainSummary.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainSummary.autoRenew(), AUTORENEW_BINDING);
            protocolMarshaller.marshall((Object)domainSummary.transferLock(), TRANSFERLOCK_BINDING);
            protocolMarshaller.marshall((Object)domainSummary.expiry(), EXPIRY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

