/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NameserverMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> GLUEIPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlueIps").isBinary(false).build();
    private static final NameserverMarshaller INSTANCE = new NameserverMarshaller();

    private NameserverMarshaller() {
    }

    public static NameserverMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Nameserver nameserver, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)nameserver, (String)"nameserver");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)nameserver.name(), NAME_BINDING);
            protocolMarshaller.marshall(nameserver.glueIps(), GLUEIPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

