/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the resource record sets that you want to update based on a specified
 * traffic policy instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrafficPolicyInstanceRequest extends Route53Request implements
        ToCopyableBuilder<UpdateTrafficPolicyInstanceRequest.Builder, UpdateTrafficPolicyInstanceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTrafficPolicyInstanceRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Long> TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateTrafficPolicyInstanceRequest::ttl))
            .setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTL").unmarshallLocationName("TTL")
                    .build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTrafficPolicyInstanceRequest::trafficPolicyId))
            .setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId")
                    .unmarshallLocationName("TrafficPolicyId").build()).build();

    private static final SdkField<Integer> TRAFFIC_POLICY_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateTrafficPolicyInstanceRequest::trafficPolicyVersion))
            .setter(setter(Builder::trafficPolicyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyVersion")
                    .unmarshallLocationName("TrafficPolicyVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TTL_FIELD,
            TRAFFIC_POLICY_ID_FIELD, TRAFFIC_POLICY_VERSION_FIELD));

    private final String id;

    private final Long ttl;

    private final String trafficPolicyId;

    private final Integer trafficPolicyVersion;

    private UpdateTrafficPolicyInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ttl = builder.ttl;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
    }

    /**
     * <p>
     * The ID of the traffic policy instance that you want to update.
     * </p>
     * 
     * @return The ID of the traffic policy instance that you want to update.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
     * </p>
     * 
     * @return The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
     */
    public Long ttl() {
        return ttl;
    }

    /**
     * <p>
     * The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
     * specified traffic policy instance.
     * </p>
     * 
     * @return The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
     *         specified traffic policy instance.
     */
    public String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
     * specified traffic policy instance.
     * </p>
     * 
     * @return The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for
     *         the specified traffic policy instance.
     */
    public Integer trafficPolicyVersion() {
        return trafficPolicyVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyInstanceRequest)) {
            return false;
        }
        UpdateTrafficPolicyInstanceRequest other = (UpdateTrafficPolicyInstanceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId())
                && Objects.equals(trafficPolicyVersion(), other.trafficPolicyVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTrafficPolicyInstanceRequest").add("Id", id()).add("TTL", ttl())
                .add("TrafficPolicyId", trafficPolicyId()).add("TrafficPolicyVersion", trafficPolicyVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "TTL":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        case "TrafficPolicyVersion":
            return Optional.ofNullable(clazz.cast(trafficPolicyVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrafficPolicyInstanceRequest, T> g) {
        return obj -> g.apply((UpdateTrafficPolicyInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTrafficPolicyInstanceRequest> {
        /**
         * <p>
         * The ID of the traffic policy instance that you want to update.
         * </p>
         * 
         * @param id
         *        The ID of the traffic policy instance that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
         * </p>
         * 
         * @param ttl
         *        The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
         * specified traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for
         *        the specified traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the
         * specified traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyVersion
         *        The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets
         *        for the specified traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersion(Integer trafficPolicyVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String id;

        private Long ttl;

        private String trafficPolicyId;

        private Integer trafficPolicyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyInstanceRequest model) {
            super(model);
            id(model.id);
            ttl(model.ttl);
            trafficPolicyId(model.trafficPolicyId);
            trafficPolicyVersion(model.trafficPolicyVersion);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Long getTtl() {
            return ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrafficPolicyInstanceRequest build() {
            return new UpdateTrafficPolicyInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
