/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>CreateTrafficPolicy</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficPolicyResponse extends Route53Response implements
        ToCopyableBuilder<CreateTrafficPolicyResponse.Builder, CreateTrafficPolicyResponse> {
    private static final SdkField<TrafficPolicy> TRAFFIC_POLICY_FIELD = SdkField
            .<TrafficPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateTrafficPolicyResponse::trafficPolicy))
            .setter(setter(Builder::trafficPolicy))
            .constructor(TrafficPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicy")
                    .unmarshallLocationName("TrafficPolicy").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficPolicyResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_FIELD,
            LOCATION_FIELD));

    private final TrafficPolicy trafficPolicy;

    private final String location;

    private CreateTrafficPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicy = builder.trafficPolicy;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains settings for the new traffic policy.
     * </p>
     * 
     * @return A complex type that contains settings for the new traffic policy.
     */
    public TrafficPolicy trafficPolicy() {
        return trafficPolicy;
    }

    /**
     * <p>
     * A unique URL that represents a new traffic policy.
     * </p>
     * 
     * @return A unique URL that represents a new traffic policy.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyResponse)) {
            return false;
        }
        CreateTrafficPolicyResponse other = (CreateTrafficPolicyResponse) obj;
        return Objects.equals(trafficPolicy(), other.trafficPolicy()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTrafficPolicyResponse").add("TrafficPolicy", trafficPolicy()).add("Location", location())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicy":
            return Optional.ofNullable(clazz.cast(trafficPolicy()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyResponse, T> g) {
        return obj -> g.apply((CreateTrafficPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficPolicyResponse> {
        /**
         * <p>
         * A complex type that contains settings for the new traffic policy.
         * </p>
         * 
         * @param trafficPolicy
         *        A complex type that contains settings for the new traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicy(TrafficPolicy trafficPolicy);

        /**
         * <p>
         * A complex type that contains settings for the new traffic policy.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPolicy.Builder} avoiding the need to
         * create one manually via {@link TrafficPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #trafficPolicy(TrafficPolicy)}.
         * 
         * @param trafficPolicy
         *        a consumer that will call methods on {@link TrafficPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicy(TrafficPolicy)
         */
        default Builder trafficPolicy(Consumer<TrafficPolicy.Builder> trafficPolicy) {
            return trafficPolicy(TrafficPolicy.builder().applyMutation(trafficPolicy).build());
        }

        /**
         * <p>
         * A unique URL that represents a new traffic policy.
         * </p>
         * 
         * @param location
         *        A unique URL that represents a new traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private TrafficPolicy trafficPolicy;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyResponse model) {
            super(model);
            trafficPolicy(model.trafficPolicy);
            location(model.location);
        }

        public final TrafficPolicy.Builder getTrafficPolicy() {
            return trafficPolicy != null ? trafficPolicy.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicy(TrafficPolicy trafficPolicy) {
            this.trafficPolicy = trafficPolicy;
            return this;
        }

        public final void setTrafficPolicy(TrafficPolicy.BuilderImpl trafficPolicy) {
            this.trafficPolicy = trafficPolicy != null ? trafficPolicy.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateTrafficPolicyResponse build() {
            return new CreateTrafficPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
