/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get information about the traffic policy instances that you created by using the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficPolicyInstancesRequest extends Route53Request implements
        ToCopyableBuilder<ListTrafficPolicyInstancesRequest.Builder, ListTrafficPolicyInstancesRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrafficPolicyInstancesRequest::hostedZoneIdMarker))
            .setter(setter(Builder::hostedZoneIdMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hostedzoneid")
                    .unmarshallLocationName("hostedzoneid").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrafficPolicyInstancesRequest::trafficPolicyInstanceNameMarker))
            .setter(setter(Builder::trafficPolicyInstanceNameMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancename")
                    .unmarshallLocationName("trafficpolicyinstancename").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrafficPolicyInstancesRequest::trafficPolicyInstanceTypeMarkerAsString))
            .setter(setter(Builder::trafficPolicyInstanceTypeMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancetype")
                    .unmarshallLocationName("trafficpolicyinstancetype").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListTrafficPolicyInstancesRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_MARKER_FIELD,
            TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String hostedZoneIdMarker;

    private final String trafficPolicyInstanceNameMarker;

    private final String trafficPolicyInstanceTypeMarker;

    private final String maxItems;

    private ListTrafficPolicyInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>HostedZoneId</code>, specify the value of <code>HostedZoneIdMarker</code> from
     * the previous response, which is the hosted zone ID of the first traffic policy instance in the next group of
     * traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the
     *         value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the
     *         first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public String hostedZoneIdMarker() {
        return hostedZoneIdMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>trafficpolicyinstancename</code>, specify the value of
     * <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic
     * policy instance in the next group of traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
     *         specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is
     *         the name of the first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public String trafficPolicyInstanceNameMarker() {
        return trafficPolicyInstanceNameMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic
     * policy instance in the next group of traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerAsString}.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
     *         specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is
     *         the type of the first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     * @see RRType
     */
    public RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(trafficPolicyInstanceTypeMarker);
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code>
     * request. For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic
     * policy instance in the next group of traffic policy instances.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerAsString}.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
     *         specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is
     *         the type of the first traffic policy instance in the next group of traffic policy instances.</p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     * @see RRType
     */
    public String trafficPolicyInstanceTypeMarkerAsString() {
        return trafficPolicyInstanceTypeMarker;
    }

    /**
     * <p>
     * The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a
     * <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy
     * instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the values
     * of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     * <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of
     * <code>MaxItems</code> traffic policy instances.
     * </p>
     * 
     * @return The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a
     *         <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic
     *         policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
     *         and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     *         <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next
     *         group of <code>MaxItems</code> traffic policy instances.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceTypeMarkerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesRequest other = (ListTrafficPolicyInstancesRequest) obj;
        return Objects.equals(hostedZoneIdMarker(), other.hostedZoneIdMarker())
                && Objects.equals(trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker())
                && Objects.equals(trafficPolicyInstanceTypeMarkerAsString(), other.trafficPolicyInstanceTypeMarkerAsString())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTrafficPolicyInstancesRequest").add("HostedZoneIdMarker", hostedZoneIdMarker())
                .add("TrafficPolicyInstanceNameMarker", trafficPolicyInstanceNameMarker())
                .add("TrafficPolicyInstanceTypeMarker", trafficPolicyInstanceTypeMarkerAsString()).add("MaxItems", maxItems())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneIdMarker":
            return Optional.ofNullable(clazz.cast(hostedZoneIdMarker()));
        case "TrafficPolicyInstanceNameMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceNameMarker()));
        case "TrafficPolicyInstanceTypeMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceTypeMarkerAsString()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyInstancesRequest, T> g) {
        return obj -> g.apply((ListTrafficPolicyInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListTrafficPolicyInstancesRequest> {
        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify the
         * value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first
         * traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param hostedZoneIdMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>, specify
         *        the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID
         *        of the first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneIdMarker(String hostedZoneIdMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
         * specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the
         * name of the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceNameMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of
         *        <code>trafficpolicyinstancename</code>, specify the value of
         *        <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
         * specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the
         * type of the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of
         *        <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the
         *        first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
         * specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the
         * type of the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstances</code> request. For the value of
         *        <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the
         *        first traffic policy instance in the next group of traffic policy instances.</p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a
         * <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic policy
         * instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>, and the
         * values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         * <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of
         * <code>MaxItems</code> traffic policy instances.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to
         *        a <code>ListTrafficPolicyInstances</code> request. If you have more than <code>MaxItems</code> traffic
         *        policy instances, the value of the <code>IsTruncated</code> element in the response is
         *        <code>true</code>, and the values of <code>HostedZoneIdMarker</code>,
         *        <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
         *        represent the first traffic policy instance in the next group of <code>MaxItems</code> traffic policy
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneIdMarker;

        private String trafficPolicyInstanceNameMarker;

        private String trafficPolicyInstanceTypeMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesRequest model) {
            super(model);
            hostedZoneIdMarker(model.hostedZoneIdMarker);
            trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            maxItems(model.maxItems);
        }

        public final String getHostedZoneIdMarker() {
            return hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarkerAsString() {
            return trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker == null ? null : trafficPolicyInstanceTypeMarker
                    .toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPolicyInstancesRequest build() {
            return new ListTrafficPolicyInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
