/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHostedZonesResponse extends Route53Response implements
        ToCopyableBuilder<ListHostedZonesResponse.Builder, ListHostedZonesResponse> {
    private static final SdkField<List<HostedZone>> HOSTED_ZONES_FIELD = SdkField
            .<List<HostedZone>> builder(MarshallingType.LIST)
            .getter(getter(ListHostedZonesResponse::hostedZones))
            .setter(setter(Builder::hostedZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZones")
                    .unmarshallLocationName("HostedZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HostedZone")
                            .memberFieldInfo(
                                    SdkField.<HostedZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(HostedZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HostedZone").unmarshallLocationName("HostedZone").build())
                                            .build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListHostedZonesResponse::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListHostedZonesResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListHostedZonesResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListHostedZonesResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONES_FIELD,
            MARKER_FIELD, IS_TRUNCATED_FIELD, NEXT_MARKER_FIELD, MAX_ITEMS_FIELD));

    private final List<HostedZone> hostedZones;

    private final String marker;

    private final Boolean isTruncated;

    private final String nextMarker;

    private final String maxItems;

    private ListHostedZonesResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZones = builder.hostedZones;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * Returns true if the HostedZones property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHostedZones() {
        return hostedZones != null && !(hostedZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains general information about the hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHostedZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains general information about the hosted zone.
     */
    public List<HostedZone> hostedZones() {
        return hostedZones;
    }

    /**
     * <p>
     * For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you
     * specified for the <code>marker</code> parameter in the request that produced the current response.
     * </p>
     * 
     * @return For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value
     *         that you specified for the <code>marker</code> parameter in the request that produced the current
     *         response.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get
     * more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of
     * <code>NextMarker</code> in the <code>marker</code> parameter.
     * </p>
     * 
     * @return A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you
     *         can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the
     *         value of <code>NextMarker</code> in the <code>marker</code> parameter.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
     * hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify
     * the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is <code>true</code>.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
     *         first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request,
     *         and specify the value of <code>NextMarker</code> from the response in the <code>marker</code>
     *         parameter.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is <code>true</code>.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code>
     * that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the call to
     *         <code>ListHostedZones</code> that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZones());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesResponse)) {
            return false;
        }
        ListHostedZonesResponse other = (ListHostedZonesResponse) obj;
        return Objects.equals(hostedZones(), other.hostedZones()) && Objects.equals(marker(), other.marker())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHostedZonesResponse").add("HostedZones", hostedZones()).add("Marker", marker())
                .add("IsTruncated", isTruncated()).add("NextMarker", nextMarker()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZones":
            return Optional.ofNullable(clazz.cast(hostedZones()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesResponse, T> g) {
        return obj -> g.apply((ListHostedZonesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListHostedZonesResponse> {
        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(Collection<HostedZone> hostedZones);

        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(HostedZone... hostedZones);

        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HostedZone>.Builder} avoiding the need to
         * create one manually via {@link List<HostedZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HostedZone>.Builder#build()} is called immediately and its
         * result is passed to {@link #hostedZones(List<HostedZone>)}.
         * 
         * @param hostedZones
         *        a consumer that will call methods on {@link List<HostedZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZones(List<HostedZone>)
         */
        Builder hostedZones(Consumer<HostedZone.Builder>... hostedZones);

        /**
         * <p>
         * For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that
         * you specified for the <code>marker</code> parameter in the request that produced the current response.
         * </p>
         * 
         * @param marker
         *        For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value
         *        that you specified for the <code>marker</code> parameter in the request that produced the current
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can
         * get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of
         * <code>NextMarker</code> in the <code>marker</code> parameter.
         * </p>
         * 
         * @param isTruncated
         *        A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you
         *        can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying
         *        the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
         * hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and
         * specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
         *        first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code>
         *        request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code>
         *        parameter.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the call to
         * <code>ListHostedZones</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the call to
         *        <code>ListHostedZones</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HostedZone> hostedZones = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Boolean isTruncated;

        private String nextMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesResponse model) {
            super(model);
            hostedZones(model.hostedZones);
            marker(model.marker);
            isTruncated(model.isTruncated);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
        }

        public final Collection<HostedZone.Builder> getHostedZones() {
            return hostedZones != null ? hostedZones.stream().map(HostedZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone... hostedZones) {
            hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(Consumer<HostedZone.Builder>... hostedZones) {
            hostedZones(Stream.of(hostedZones).map(c -> HostedZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHostedZones(Collection<HostedZone.BuilderImpl> hostedZones) {
            this.hostedZones = HostedZonesCopier.copyFromBuilder(hostedZones);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHostedZonesResponse build() {
            return new ListHostedZonesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
