/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to retrieve a list of the public and private hosted zones that are associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHostedZonesRequest extends Route53Request implements
        ToCopyableBuilder<ListHostedZonesRequest.Builder, ListHostedZonesRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListHostedZonesRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker")
                    .unmarshallLocationName("marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListHostedZonesRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final SdkField<String> DELEGATION_SET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ListHostedZonesRequest::delegationSetId))
            .setter(setter(Builder::delegationSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("delegationsetid")
                    .unmarshallLocationName("delegationsetid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            DELEGATION_SET_ID_FIELD));

    private final String marker;

    private final String maxItems;

    private final String delegationSetId;

    private ListHostedZonesRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.delegationSetId = builder.delegationSetId;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted
     * zones. To get more hosted zones, submit another <code>ListHostedZones</code> request.
     * </p>
     * <p>
     * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
     * which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * hosted zones to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
     *         <p>
     *         For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
     *         response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another
     *         request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more hosted zones to get.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than
     * <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>,
     * and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone that Route 53 will return
     * if you submit another request.
     * </p>
     * 
     * @return (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more
     *         than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is
     *         <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted
     *         zone that Route 53 will return if you submit another request.
     */
    public String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * If you're using reusable delegation sets and you want to list all of the hosted zones that are associated with a
     * reusable delegation set, specify the ID of that reusable delegation set.
     * </p>
     * 
     * @return If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
     *         with a reusable delegation set, specify the ID of that reusable delegation set.
     */
    public String delegationSetId() {
        return delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesRequest)) {
            return false;
        }
        ListHostedZonesRequest other = (ListHostedZonesRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(delegationSetId(), other.delegationSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHostedZonesRequest").add("Marker", marker()).add("MaxItems", maxItems())
                .add("DelegationSetId", delegationSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "DelegationSetId":
            return Optional.ofNullable(clazz.cast(delegationSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesRequest, T> g) {
        return obj -> g.apply((ListHostedZonesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListHostedZonesRequest> {
        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted
         * zones. To get more hosted zones, submit another <code>ListHostedZones</code> request.
         * </p>
         * <p>
         * For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         * response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another
         * request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * hosted zones to get.
         * </p>
         * 
         * @param marker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        hosted zones. To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
         *        <p>
         *        For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous
         *        response, which is the ID of the first hosted zone that Amazon Route 53 will return if you submit
         *        another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more hosted zones to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than
         * <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is
         * <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted zone
         * that Route 53 will return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have
         *        more than <code>maxitems</code> hosted zones, the value of <code>IsTruncated</code> in the response is
         *        <code>true</code>, and the value of <code>NextMarker</code> is the hosted zone ID of the first hosted
         *        zone that Route 53 will return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
         * with a reusable delegation set, specify the ID of that reusable delegation set.
         * </p>
         * 
         * @param delegationSetId
         *        If you're using reusable delegation sets and you want to list all of the hosted zones that are
         *        associated with a reusable delegation set, specify the ID of that reusable delegation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSetId(String delegationSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            delegationSetId(model.delegationSetId);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public final String getDelegationSetId() {
            return delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHostedZonesRequest build() {
            return new ListHostedZonesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
