/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a geographic location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoLocation implements SdkPojo, Serializable, ToCopyableBuilder<GeoLocation.Builder, GeoLocation> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GeoLocation::continentCode))
            .setter(setter(Builder::continentCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinentCode")
                    .unmarshallLocationName("ContinentCode").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GeoLocation::countryCode))
            .setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode")
                    .unmarshallLocationName("CountryCode").build()).build();

    private static final SdkField<String> SUBDIVISION_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GeoLocation::subdivisionCode))
            .setter(setter(Builder::subdivisionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubdivisionCode")
                    .unmarshallLocationName("SubdivisionCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD,
            COUNTRY_CODE_FIELD, SUBDIVISION_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String continentCode;

    private final String countryCode;

    private final String subdivisionCode;

    private GeoLocation(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
    }

    /**
     * <p>
     * The two-letter code for the continent.
     * </p>
     * <p>
     * Amazon Route 53 supports the following continent codes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AF</b>: Africa
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AN</b>: Antarctica
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AS</b>: Asia
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EU</b>: Europe
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OC</b>: Oceania
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NA</b>: North America
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SA</b>: South America
     * </p>
     * </li>
     * </ul>
     * <p>
     * Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
     * <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
     * </p>
     * 
     * @return The two-letter code for the continent.</p>
     *         <p>
     *         Amazon Route 53 supports the following continent codes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AF</b>: Africa
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AN</b>: Antarctica
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AS</b>: Asia
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EU</b>: Europe
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>OC</b>: Oceania
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NA</b>: North America
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SA</b>: South America
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
     *         <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
     */
    public String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * For geolocation resource record sets, the two-letter code for a country.
     * </p>
     * <p>
     * Amazon Route 53 uses the two-letter country codes that are specified in <a
     * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     * </p>
     * 
     * @return For geolocation resource record sets, the two-letter code for a country.</p>
     *         <p>
     *         Amazon Route 53 uses the two-letter country codes that are specified in <a
     *         href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     */
    public String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * For geolocation resource record sets, the two-letter code for a state of the United States. Route 53 doesn't
     * support any other values for <code>SubdivisionCode</code>. For a list of state abbreviations, see <a
     * href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on
     * the United States Postal Service website.
     * </p>
     * <p>
     * If you specify <code>subdivisioncode</code>, you must also specify <code>US</code> for <code>CountryCode</code>.
     * </p>
     * 
     * @return For geolocation resource record sets, the two-letter code for a state of the United States. Route 53
     *         doesn't support any other values for <code>SubdivisionCode</code>. For a list of state abbreviations, see
     *         <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession
     *         Abbreviations</a> on the United States Postal Service website. </p>
     *         <p>
     *         If you specify <code>subdivisioncode</code>, you must also specify <code>US</code> for
     *         <code>CountryCode</code>.
     */
    public String subdivisionCode() {
        return subdivisionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(subdivisionCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation) obj;
        return Objects.equals(continentCode(), other.continentCode()) && Objects.equals(countryCode(), other.countryCode())
                && Objects.equals(subdivisionCode(), other.subdivisionCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GeoLocation").add("ContinentCode", continentCode()).add("CountryCode", countryCode())
                .add("SubdivisionCode", subdivisionCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinentCode":
            return Optional.ofNullable(clazz.cast(continentCode()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "SubdivisionCode":
            return Optional.ofNullable(clazz.cast(subdivisionCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoLocation, T> g) {
        return obj -> g.apply((GeoLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeoLocation> {
        /**
         * <p>
         * The two-letter code for the continent.
         * </p>
         * <p>
         * Amazon Route 53 supports the following continent codes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AF</b>: Africa
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AN</b>: Antarctica
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AS</b>: Asia
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EU</b>: Europe
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OC</b>: Oceania
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NA</b>: North America
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SA</b>: South America
         * </p>
         * </li>
         * </ul>
         * <p>
         * Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
         * <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
         * </p>
         * 
         * @param continentCode
         *        The two-letter code for the continent.</p>
         *        <p>
         *        Amazon Route 53 supports the following continent codes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AF</b>: Africa
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AN</b>: Antarctica
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AS</b>: Asia
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EU</b>: Europe
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>OC</b>: Oceania
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NA</b>: North America
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SA</b>: South America
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
         *        <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * For geolocation resource record sets, the two-letter code for a country.
         * </p>
         * <p>
         * Amazon Route 53 uses the two-letter country codes that are specified in <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * </p>
         * 
         * @param countryCode
         *        For geolocation resource record sets, the two-letter code for a country.</p>
         *        <p>
         *        Amazon Route 53 uses the two-letter country codes that are specified in <a
         *        href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * For geolocation resource record sets, the two-letter code for a state of the United States. Route 53 doesn't
         * support any other values for <code>SubdivisionCode</code>. For a list of state abbreviations, see <a
         * href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a>
         * on the United States Postal Service website.
         * </p>
         * <p>
         * If you specify <code>subdivisioncode</code>, you must also specify <code>US</code> for
         * <code>CountryCode</code>.
         * </p>
         * 
         * @param subdivisionCode
         *        For geolocation resource record sets, the two-letter code for a state of the United States. Route 53
         *        doesn't support any other values for <code>SubdivisionCode</code>. For a list of state abbreviations,
         *        see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession
         *        Abbreviations</a> on the United States Postal Service website. </p>
         *        <p>
         *        If you specify <code>subdivisioncode</code>, you must also specify <code>US</code> for
         *        <code>CountryCode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivisionCode(String subdivisionCode);
    }

    static final class BuilderImpl implements Builder {
        private String continentCode;

        private String countryCode;

        private String subdivisionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocation model) {
            continentCode(model.continentCode);
            countryCode(model.countryCode);
            subdivisionCode(model.subdivisionCode);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getSubdivisionCode() {
            return subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        @Override
        public GeoLocation build() {
            return new GeoLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
