/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeBatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeBatch> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ChangeBatch.getter(ChangeBatch::comment)).setter(ChangeBatch.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<List<Change>> CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ChangeBatch.getter(ChangeBatch::changes)).setter(ChangeBatch.setter(Builder::changes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").unmarshallLocationName("Changes").build(), ListTrait.builder().memberLocationName("Change").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Change::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Change").unmarshallLocationName("Change").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CHANGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final List<Change> changes;

    private ChangeBatch(BuilderImpl builder) {
        this.comment = builder.comment;
        this.changes = builder.changes;
    }

    public String comment() {
        return this.comment;
    }

    public boolean hasChanges() {
        return this.changes != null && !(this.changes instanceof SdkAutoConstructList);
    }

    public List<Change> changes() {
        return this.changes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.changes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeBatch)) {
            return false;
        }
        ChangeBatch other = (ChangeBatch)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.changes(), other.changes());
    }

    public String toString() {
        return ToString.builder((String)"ChangeBatch").add("Comment", (Object)this.comment()).add("Changes", this.changes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Changes": {
                return Optional.ofNullable(clazz.cast(this.changes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangeBatch, T> g) {
        return obj -> g.apply((ChangeBatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private List<Change> changes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeBatch model) {
            this.comment(model.comment);
            this.changes(model.changes);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Collection<Change.Builder> getChanges() {
            return this.changes != null ? (Collection)this.changes.stream().map(Change::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<Change.Builder> ... changes) {
            this.changes(Stream.of(changes).map(c -> (Change)((Change.Builder)Change.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangesCopier.copyFromBuilder(changes);
        }

        public ChangeBatch build() {
            return new ChangeBatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeBatch> {
        public Builder comment(String var1);

        public Builder changes(Collection<Change> var1);

        public Builder changes(Change ... var1);

        public Builder changes(Consumer<Change.Builder> ... var1);
    }
}

