/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheck</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHealthCheckStatusResponse extends Route53Response implements
        ToCopyableBuilder<GetHealthCheckStatusResponse.Builder, GetHealthCheckStatusResponse> {
    private static final SdkField<List<HealthCheckObservation>> HEALTH_CHECK_OBSERVATIONS_FIELD = SdkField
            .<List<HealthCheckObservation>> builder(MarshallingType.LIST)
            .memberName("HealthCheckObservations")
            .getter(getter(GetHealthCheckStatusResponse::healthCheckObservations))
            .setter(setter(Builder::healthCheckObservations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckObservations")
                    .unmarshallLocationName("HealthCheckObservations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HealthCheckObservation")
                            .memberFieldInfo(
                                    SdkField.<HealthCheckObservation> builder(MarshallingType.SDK_POJO)
                                            .constructor(HealthCheckObservation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HealthCheckObservation")
                                                    .unmarshallLocationName("HealthCheckObservation").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HEALTH_CHECK_OBSERVATIONS_FIELD));

    private final List<HealthCheckObservation> healthCheckObservations;

    private GetHealthCheckStatusResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheckObservations = builder.healthCheckObservations;
    }

    /**
     * Returns true if the HealthCheckObservations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasHealthCheckObservations() {
        return healthCheckObservations != null && !(healthCheckObservations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that
     * is reporting a status about the health check endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHealthCheckObservations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
     *         checker that is reporting a status about the health check endpoint.
     */
    public List<HealthCheckObservation> healthCheckObservations() {
        return healthCheckObservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckObservations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckStatusResponse)) {
            return false;
        }
        GetHealthCheckStatusResponse other = (GetHealthCheckStatusResponse) obj;
        return Objects.equals(healthCheckObservations(), other.healthCheckObservations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetHealthCheckStatusResponse").add("HealthCheckObservations", healthCheckObservations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckObservations":
            return Optional.ofNullable(clazz.cast(healthCheckObservations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHealthCheckStatusResponse, T> g) {
        return obj -> g.apply((GetHealthCheckStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetHealthCheckStatusResponse> {
        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
         *        checker that is reporting a status about the health check endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
         *        checker that is reporting a status about the health check endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HealthCheckObservation>.Builder} avoiding
         * the need to create one manually via {@link List<HealthCheckObservation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HealthCheckObservation>.Builder#build()} is called
         * immediately and its result is passed to {@link #healthCheckObservations(List<HealthCheckObservation>)}.
         * 
         * @param healthCheckObservations
         *        a consumer that will call methods on {@link List<HealthCheckObservation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckObservations(List<HealthCheckObservation>)
         */
        Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder>... healthCheckObservations);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HealthCheckObservation> healthCheckObservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckStatusResponse model) {
            super(model);
            healthCheckObservations(model.healthCheckObservations);
        }

        public final Collection<HealthCheckObservation.Builder> getHealthCheckObservations() {
            return healthCheckObservations != null ? healthCheckObservations.stream().map(HealthCheckObservation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations) {
            healthCheckObservations(Arrays.asList(healthCheckObservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder>... healthCheckObservations) {
            healthCheckObservations(Stream.of(healthCheckObservations)
                    .map(c -> HealthCheckObservation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHealthCheckObservations(Collection<HealthCheckObservation.BuilderImpl> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copyFromBuilder(healthCheckObservations);
        }

        @Override
        public GetHealthCheckStatusResponse build() {
            return new GetHealthCheckStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
