/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource record sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGeoLocationsRequest extends Route53Request implements
        ToCopyableBuilder<ListGeoLocationsRequest.Builder, ListGeoLocationsRequest> {
    private static final SdkField<String> START_CONTINENT_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartContinentCode")
            .getter(getter(ListGeoLocationsRequest::startContinentCode))
            .setter(setter(Builder::startContinentCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startcontinentcode")
                    .unmarshallLocationName("startcontinentcode").build()).build();

    private static final SdkField<String> START_COUNTRY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartCountryCode")
            .getter(getter(ListGeoLocationsRequest::startCountryCode))
            .setter(setter(Builder::startCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startcountrycode")
                    .unmarshallLocationName("startcountrycode").build()).build();

    private static final SdkField<String> START_SUBDIVISION_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartSubdivisionCode")
            .getter(getter(ListGeoLocationsRequest::startSubdivisionCode))
            .setter(setter(Builder::startSubdivisionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startsubdivisioncode")
                    .unmarshallLocationName("startsubdivisioncode").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListGeoLocationsRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_CONTINENT_CODE_FIELD,
            START_COUNTRY_CODE_FIELD, START_SUBDIVISION_CODE_FIELD, MAX_ITEMS_FIELD));

    private final String startContinentCode;

    private final String startCountryCode;

    private final String startSubdivisionCode;

    private final String maxItems;

    private ListGeoLocationsRequest(BuilderImpl builder) {
        super(builder);
        this.startContinentCode = builder.startContinentCode;
        this.startCountryCode = builder.startCountryCode;
        this.startSubdivisionCode = builder.startSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The code for the continent with which you want to start listing locations that Amazon Route 53 supports for
     * geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true, and
     * if <code>NextContinentCode</code> from the previous response has a value, enter that value in
     * <code>startcontinentcode</code> to return the next page of results.
     * </p>
     * <p>
     * Include <code>startcontinentcode</code> only if you want to list continents. Don't include
     * <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.
     * </p>
     * 
     * @return The code for the continent with which you want to start listing locations that Amazon Route 53 supports
     *         for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code>
     *         is true, and if <code>NextContinentCode</code> from the previous response has a value, enter that value
     *         in <code>startcontinentcode</code> to return the next page of results.</p>
     *         <p>
     *         Include <code>startcontinentcode</code> only if you want to list continents. Don't include
     *         <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.
     */
    public String startContinentCode() {
        return startContinentCode;
    }

    /**
     * <p>
     * The code for the country with which you want to start listing locations that Amazon Route 53 supports for
     * geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is
     * <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that value
     * in <code>startcountrycode</code> to return the next page of results.
     * </p>
     * 
     * @return The code for the country with which you want to start listing locations that Amazon Route 53 supports for
     *         geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is
     *         <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that
     *         value in <code>startcountrycode</code> to return the next page of results.
     */
    public String startCountryCode() {
        return startCountryCode;
    }

    /**
     * <p>
     * The code for the state of the United States with which you want to start listing locations that Amazon Route 53
     * supports for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code>
     * is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous response has a value, enter that
     * value in <code>startsubdivisioncode</code> to return the next page of results.
     * </p>
     * <p>
     * To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and
     * <code>startsubdivisioncode</code>.
     * </p>
     * 
     * @return The code for the state of the United States with which you want to start listing locations that Amazon
     *         Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if
     *         <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous
     *         response has a value, enter that value in <code>startsubdivisioncode</code> to return the next page of
     *         results.</p>
     *         <p>
     *         To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and
     *         <code>startsubdivisioncode</code>.
     */
    public String startSubdivisionCode() {
        return startSubdivisionCode;
    }

    /**
     * <p>
     * (Optional) The maximum number of geolocations to be included in the response body for this request. If more than
     * <code>maxitems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in
     * the response is <code>true</code>.
     * </p>
     * 
     * @return (Optional) The maximum number of geolocations to be included in the response body for this request. If
     *         more than <code>maxitems</code> geolocations remain to be listed, then the value of the
     *         <code>IsTruncated</code> element in the response is <code>true</code>.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startContinentCode());
        hashCode = 31 * hashCode + Objects.hashCode(startCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(startSubdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsRequest)) {
            return false;
        }
        ListGeoLocationsRequest other = (ListGeoLocationsRequest) obj;
        return Objects.equals(startContinentCode(), other.startContinentCode())
                && Objects.equals(startCountryCode(), other.startCountryCode())
                && Objects.equals(startSubdivisionCode(), other.startSubdivisionCode())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListGeoLocationsRequest").add("StartContinentCode", startContinentCode())
                .add("StartCountryCode", startCountryCode()).add("StartSubdivisionCode", startSubdivisionCode())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartContinentCode":
            return Optional.ofNullable(clazz.cast(startContinentCode()));
        case "StartCountryCode":
            return Optional.ofNullable(clazz.cast(startCountryCode()));
        case "StartSubdivisionCode":
            return Optional.ofNullable(clazz.cast(startSubdivisionCode()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGeoLocationsRequest, T> g) {
        return obj -> g.apply((ListGeoLocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListGeoLocationsRequest> {
        /**
         * <p>
         * The code for the continent with which you want to start listing locations that Amazon Route 53 supports for
         * geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is true,
         * and if <code>NextContinentCode</code> from the previous response has a value, enter that value in
         * <code>startcontinentcode</code> to return the next page of results.
         * </p>
         * <p>
         * Include <code>startcontinentcode</code> only if you want to list continents. Don't include
         * <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.
         * </p>
         * 
         * @param startContinentCode
         *        The code for the continent with which you want to start listing locations that Amazon Route 53
         *        supports for geolocation. If Route 53 has already returned a page or more of results, if
         *        <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous response has
         *        a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
         *        <p>
         *        Include <code>startcontinentcode</code> only if you want to list continents. Don't include
         *        <code>startcontinentcode</code> when you're listing countries or countries with their subdivisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startContinentCode(String startContinentCode);

        /**
         * <p>
         * The code for the country with which you want to start listing locations that Amazon Route 53 supports for
         * geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is
         * <code>true</code>, and if <code>NextCountryCode</code> from the previous response has a value, enter that
         * value in <code>startcountrycode</code> to return the next page of results.
         * </p>
         * 
         * @param startCountryCode
         *        The code for the country with which you want to start listing locations that Amazon Route 53 supports
         *        for geolocation. If Route 53 has already returned a page or more of results, if
         *        <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the previous
         *        response has a value, enter that value in <code>startcountrycode</code> to return the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startCountryCode(String startCountryCode);

        /**
         * <p>
         * The code for the state of the United States with which you want to start listing locations that Amazon Route
         * 53 supports for geolocation. If Route 53 has already returned a page or more of results, if
         * <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the previous
         * response has a value, enter that value in <code>startsubdivisioncode</code> to return the next page of
         * results.
         * </p>
         * <p>
         * To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and
         * <code>startsubdivisioncode</code>.
         * </p>
         * 
         * @param startSubdivisionCode
         *        The code for the state of the United States with which you want to start listing locations that Amazon
         *        Route 53 supports for geolocation. If Route 53 has already returned a page or more of results, if
         *        <code>IsTruncated</code> is <code>true</code>, and if <code>NextSubdivisionCode</code> from the
         *        previous response has a value, enter that value in <code>startsubdivisioncode</code> to return the
         *        next page of results.</p>
         *        <p>
         *        To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and
         *        <code>startsubdivisioncode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSubdivisionCode(String startSubdivisionCode);

        /**
         * <p>
         * (Optional) The maximum number of geolocations to be included in the response body for this request. If more
         * than <code>maxitems</code> geolocations remain to be listed, then the value of the <code>IsTruncated</code>
         * element in the response is <code>true</code>.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of geolocations to be included in the response body for this request. If
         *        more than <code>maxitems</code> geolocations remain to be listed, then the value of the
         *        <code>IsTruncated</code> element in the response is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String startContinentCode;

        private String startCountryCode;

        private String startSubdivisionCode;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsRequest model) {
            super(model);
            startContinentCode(model.startContinentCode);
            startCountryCode(model.startCountryCode);
            startSubdivisionCode(model.startSubdivisionCode);
            maxItems(model.maxItems);
        }

        public final String getStartContinentCode() {
            return startContinentCode;
        }

        @Override
        public final Builder startContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
            return this;
        }

        public final void setStartContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
        }

        public final String getStartCountryCode() {
            return startCountryCode;
        }

        @Override
        public final Builder startCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
            return this;
        }

        public final void setStartCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
        }

        public final String getStartSubdivisionCode() {
            return startSubdivisionCode;
        }

        @Override
        public final Builder startSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
            return this;
        }

        public final void setStartSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGeoLocationsRequest build() {
            return new ListGeoLocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
