/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the reusable delegation sets that are associated with the current AWS
 * account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReusableDelegationSetsResponse extends Route53Response implements
        ToCopyableBuilder<ListReusableDelegationSetsResponse.Builder, ListReusableDelegationSetsResponse> {
    private static final SdkField<List<DelegationSet>> DELEGATION_SETS_FIELD = SdkField
            .<List<DelegationSet>> builder(MarshallingType.LIST)
            .memberName("DelegationSets")
            .getter(getter(ListReusableDelegationSetsResponse::delegationSets))
            .setter(setter(Builder::delegationSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSets")
                    .unmarshallLocationName("DelegationSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DelegationSet")
                            .memberFieldInfo(
                                    SdkField.<DelegationSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(DelegationSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DelegationSet").unmarshallLocationName("DelegationSet")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListReusableDelegationSetsResponse::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(ListReusableDelegationSetsResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(ListReusableDelegationSetsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListReusableDelegationSetsResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATION_SETS_FIELD,
            MARKER_FIELD, IS_TRUNCATED_FIELD, NEXT_MARKER_FIELD, MAX_ITEMS_FIELD));

    private final List<DelegationSet> delegationSets;

    private final String marker;

    private final Boolean isTruncated;

    private final String nextMarker;

    private final String maxItems;

    private ListReusableDelegationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.delegationSets = builder.delegationSets;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * Returns true if the DelegationSets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDelegationSets() {
        return delegationSets != null && !(delegationSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was
     * created by the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDelegationSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that
     *         was created by the current AWS account.
     */
    public List<DelegationSet> delegationSets() {
        return delegationSets;
    }

    /**
     * <p>
     * For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the value
     * that you specified for the <code>marker</code> parameter in the request that produced the current response.
     * </p>
     * 
     * @return For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is
     *         the value that you specified for the <code>marker</code> parameter in the request that produced the
     *         current response.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A flag that indicates whether there are more reusable delegation sets to be listed.
     * </p>
     * 
     * @return A flag that indicates whether there are more reusable delegation sets to be listed.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next
     * reusable delegation set that Amazon Route 53 will return if you submit another
     * <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the
     * <code>marker</code> parameter.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
     *         next reusable delegation set that Amazon Route 53 will return if you submit another
     *         <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the
     *         <code>marker</code> parameter.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the call to
     * <code>ListReusableDelegationSets</code> that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the call to
     *         <code>ListReusableDelegationSets</code> that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDelegationSets() ? delegationSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReusableDelegationSetsResponse)) {
            return false;
        }
        ListReusableDelegationSetsResponse other = (ListReusableDelegationSetsResponse) obj;
        return hasDelegationSets() == other.hasDelegationSets() && Objects.equals(delegationSets(), other.delegationSets())
                && Objects.equals(marker(), other.marker()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListReusableDelegationSetsResponse")
                .add("DelegationSets", hasDelegationSets() ? delegationSets() : null).add("Marker", marker())
                .add("IsTruncated", isTruncated()).add("NextMarker", nextMarker()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DelegationSets":
            return Optional.ofNullable(clazz.cast(delegationSets()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReusableDelegationSetsResponse, T> g) {
        return obj -> g.apply((ListReusableDelegationSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReusableDelegationSetsResponse> {
        /**
         * <p>
         * A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was
         * created by the current AWS account.
         * </p>
         * 
         * @param delegationSets
         *        A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set
         *        that was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSets(Collection<DelegationSet> delegationSets);

        /**
         * <p>
         * A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was
         * created by the current AWS account.
         * </p>
         * 
         * @param delegationSets
         *        A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set
         *        that was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSets(DelegationSet... delegationSets);

        /**
         * <p>
         * A complex type that contains one <code>DelegationSet</code> element for each reusable delegation set that was
         * created by the current AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DelegationSet>.Builder} avoiding the need
         * to create one manually via {@link List<DelegationSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DelegationSet>.Builder#build()} is called immediately and
         * its result is passed to {@link #delegationSets(List<DelegationSet>)}.
         * 
         * @param delegationSets
         *        a consumer that will call methods on {@link List<DelegationSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegationSets(List<DelegationSet>)
         */
        Builder delegationSets(Consumer<DelegationSet.Builder>... delegationSets);

        /**
         * <p>
         * For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is the
         * value that you specified for the <code>marker</code> parameter in the request that produced the current
         * response.
         * </p>
         * 
         * @param marker
         *        For the second and subsequent calls to <code>ListReusableDelegationSets</code>, <code>Marker</code> is
         *        the value that you specified for the <code>marker</code> parameter in the request that produced the
         *        current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A flag that indicates whether there are more reusable delegation sets to be listed.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more reusable delegation sets to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the next
         * reusable delegation set that Amazon Route 53 will return if you submit another
         * <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in the
         * <code>marker</code> parameter.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
         *        next reusable delegation set that Amazon Route 53 will return if you submit another
         *        <code>ListReusableDelegationSets</code> request and specify the value of <code>NextMarker</code> in
         *        the <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the call to
         * <code>ListReusableDelegationSets</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the call to
         *        <code>ListReusableDelegationSets</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<DelegationSet> delegationSets = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Boolean isTruncated;

        private String nextMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReusableDelegationSetsResponse model) {
            super(model);
            delegationSets(model.delegationSets);
            marker(model.marker);
            isTruncated(model.isTruncated);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
        }

        public final Collection<DelegationSet.Builder> getDelegationSets() {
            if (delegationSets instanceof SdkAutoConstructList) {
                return null;
            }
            return delegationSets != null ? delegationSets.stream().map(DelegationSet::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder delegationSets(Collection<DelegationSet> delegationSets) {
            this.delegationSets = DelegationSetsCopier.copy(delegationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegationSets(DelegationSet... delegationSets) {
            delegationSets(Arrays.asList(delegationSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegationSets(Consumer<DelegationSet.Builder>... delegationSets) {
            delegationSets(Stream.of(delegationSets).map(c -> DelegationSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDelegationSets(Collection<DelegationSet.BuilderImpl> delegationSets) {
            this.delegationSets = DelegationSetsCopier.copyFromBuilder(delegationSets);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListReusableDelegationSetsResponse build() {
            return new ListReusableDelegationSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
