/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReusableDelegationSetRequest extends Route53Request implements
        ToCopyableBuilder<CreateReusableDelegationSetRequest.Builder, CreateReusableDelegationSetRequest> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(CreateReusableDelegationSetRequest::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(CreateReusableDelegationSetRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD,
            HOSTED_ZONE_ID_FIELD));

    private final String callerReference;

    private final String hostedZoneId;

    private CreateReusableDelegationSetRequest(BuilderImpl builder) {
        super(builder);
        this.callerReference = builder.callerReference;
        this.hostedZoneId = builder.hostedZoneId;
    }

    /**
     * <p>
     * A unique string that identifies the request, and that allows you to retry failed
     * <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must use
     * a unique <code>CallerReference</code> string every time you submit a <code>CreateReusableDelegationSet</code>
     * request. <code>CallerReference</code> can be any unique string, for example a date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request, and that allows you to retry failed
     *         <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You
     *         must use a unique <code>CallerReference</code> string every time you submit a
     *         <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string,
     *         for example a date/time stamp.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.
     * </p>
     * 
     * @return If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted
     *         zone.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReusableDelegationSetRequest)) {
            return false;
        }
        CreateReusableDelegationSetRequest other = (CreateReusableDelegationSetRequest) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(hostedZoneId(), other.hostedZoneId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReusableDelegationSetRequest").add("CallerReference", callerReference())
                .add("HostedZoneId", hostedZoneId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReusableDelegationSetRequest, T> g) {
        return obj -> g.apply((CreateReusableDelegationSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReusableDelegationSetRequest> {
        /**
         * <p>
         * A unique string that identifies the request, and that allows you to retry failed
         * <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice. You must
         * use a unique <code>CallerReference</code> string every time you submit a
         * <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique string, for
         * example a date/time stamp.
         * </p>
         * 
         * @param callerReference
         *        A unique string that identifies the request, and that allows you to retry failed
         *        <code>CreateReusableDelegationSet</code> requests without the risk of executing the operation twice.
         *        You must use a unique <code>CallerReference</code> string every time you submit a
         *        <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be any unique
         *        string, for example a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        If you want to mark the delegation set for an existing hosted zone as reusable, the ID for that hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String callerReference;

        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReusableDelegationSetRequest model) {
            super(model);
            callerReference(model.callerReference);
            hostedZoneId(model.hostedZoneId);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReusableDelegationSetRequest build() {
            return new CreateReusableDelegationSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
