/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHostedZonesByNameResponse extends Route53Response implements
        ToCopyableBuilder<ListHostedZonesByNameResponse.Builder, ListHostedZonesByNameResponse> {
    private static final SdkField<List<HostedZone>> HOSTED_ZONES_FIELD = SdkField
            .<List<HostedZone>> builder(MarshallingType.LIST)
            .memberName("HostedZones")
            .getter(getter(ListHostedZonesByNameResponse::hostedZones))
            .setter(setter(Builder::hostedZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZones")
                    .unmarshallLocationName("HostedZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HostedZone")
                            .memberFieldInfo(
                                    SdkField.<HostedZone> builder(MarshallingType.SDK_POJO)
                                            .constructor(HostedZone::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HostedZone").unmarshallLocationName("HostedZone").build())
                                            .build()).build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DNSName")
            .getter(getter(ListHostedZonesByNameResponse::dnsName))
            .setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName")
                    .unmarshallLocationName("DNSName").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(ListHostedZonesByNameResponse::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId")
                    .unmarshallLocationName("HostedZoneId").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(ListHostedZonesByNameResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> NEXT_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextDNSName")
            .getter(getter(ListHostedZonesByNameResponse::nextDNSName))
            .setter(setter(Builder::nextDNSName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextDNSName")
                    .unmarshallLocationName("NextDNSName").build()).build();

    private static final SdkField<String> NEXT_HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextHostedZoneId")
            .getter(getter(ListHostedZonesByNameResponse::nextHostedZoneId))
            .setter(setter(Builder::nextHostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextHostedZoneId")
                    .unmarshallLocationName("NextHostedZoneId").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListHostedZonesByNameResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONES_FIELD,
            DNS_NAME_FIELD, HOSTED_ZONE_ID_FIELD, IS_TRUNCATED_FIELD, NEXT_DNS_NAME_FIELD, NEXT_HOSTED_ZONE_ID_FIELD,
            MAX_ITEMS_FIELD));

    private final List<HostedZone> hostedZones;

    private final String dnsName;

    private final String hostedZoneId;

    private final Boolean isTruncated;

    private final String nextDNSName;

    private final String nextHostedZoneId;

    private final String maxItems;

    private ListHostedZonesByNameResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZones = builder.hostedZones;
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.isTruncated = builder.isTruncated;
        this.nextDNSName = builder.nextDNSName;
        this.nextHostedZoneId = builder.nextHostedZoneId;
        this.maxItems = builder.maxItems;
    }

    /**
     * Returns true if the HostedZones property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHostedZones() {
        return hostedZones != null && !(hostedZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains general information about the hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHostedZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains general information about the hosted zone.
     */
    public List<HostedZone> hostedZones() {
        return hostedZones;
    }

    /**
     * <p>
     * For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value that
     * you specified for the <code>dnsname</code> parameter in the request that produced the current response.
     * </p>
     * 
     * @return For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the
     *         value that you specified for the <code>dnsname</code> parameter in the request that produced the current
     *         response.
     */
    public String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you can
     * get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code> again and
     * specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the
     * <code>dnsname</code> and <code>hostedzoneid</code> parameters.
     * </p>
     * 
     * @return A flag that indicates whether there are more hosted zones to be listed. If the response was truncated,
     *         you can get the next group of <code>maxitems</code> hosted zones by calling
     *         <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and
     *         <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code>
     *         parameters.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted zone
     * in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again and
     * specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is <code>true</code>.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first
     *         hosted zone in the next group of <code>maxitems</code> hosted zones. Call
     *         <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
     *         <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
     *         respectively.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is <code>true</code>.
     */
    public String nextDNSName() {
        return nextDNSName;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the first
     * hosted zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code>
     * again and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the
     * <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is <code>true</code>.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies
     *         the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call
     *         <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
     *         <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
     *         respectively.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is <code>true</code>.
     */
    public String nextHostedZoneId() {
        return nextHostedZoneId;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the call to
     * <code>ListHostedZonesByName</code> that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the call to
     *         <code>ListHostedZonesByName</code> that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHostedZones() ? hostedZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(nextDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(nextHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameResponse)) {
            return false;
        }
        ListHostedZonesByNameResponse other = (ListHostedZonesByNameResponse) obj;
        return hasHostedZones() == other.hasHostedZones() && Objects.equals(hostedZones(), other.hostedZones())
                && Objects.equals(dnsName(), other.dnsName()) && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(nextDNSName(), other.nextDNSName())
                && Objects.equals(nextHostedZoneId(), other.nextHostedZoneId()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHostedZonesByNameResponse").add("HostedZones", hasHostedZones() ? hostedZones() : null)
                .add("DNSName", dnsName()).add("HostedZoneId", hostedZoneId()).add("IsTruncated", isTruncated())
                .add("NextDNSName", nextDNSName()).add("NextHostedZoneId", nextHostedZoneId()).add("MaxItems", maxItems())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZones":
            return Optional.ofNullable(clazz.cast(hostedZones()));
        case "DNSName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "NextDNSName":
            return Optional.ofNullable(clazz.cast(nextDNSName()));
        case "NextHostedZoneId":
            return Optional.ofNullable(clazz.cast(nextHostedZoneId()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesByNameResponse, T> g) {
        return obj -> g.apply((ListHostedZonesByNameResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListHostedZonesByNameResponse> {
        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(Collection<HostedZone> hostedZones);

        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(HostedZone... hostedZones);

        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HostedZone>.Builder} avoiding the need to
         * create one manually via {@link List<HostedZone>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HostedZone>.Builder#build()} is called immediately and its
         * result is passed to {@link #hostedZones(List<HostedZone>)}.
         * 
         * @param hostedZones
         *        a consumer that will call methods on {@link List<HostedZone>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZones(List<HostedZone>)
         */
        Builder hostedZones(Consumer<HostedZone.Builder>... hostedZones);

        /**
         * <p>
         * For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the value
         * that you specified for the <code>dnsname</code> parameter in the request that produced the current response.
         * </p>
         * 
         * @param dnsName
         *        For the second and subsequent calls to <code>ListHostedZonesByName</code>, <code>DNSName</code> is the
         *        value that you specified for the <code>dnsname</code> parameter in the request that produced the
         *        current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * A flag that indicates whether there are more hosted zones to be listed. If the response was truncated, you
         * can get the next group of <code>maxitems</code> hosted zones by calling <code>ListHostedZonesByName</code>
         * again and specifying the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the
         * <code>dnsname</code> and <code>hostedzoneid</code> parameters.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more hosted zones to be listed. If the response was truncated,
         *        you can get the next group of <code>maxitems</code> hosted zones by calling
         *        <code>ListHostedZonesByName</code> again and specifying the values of <code>NextDNSName</code> and
         *        <code>NextHostedZoneId</code> elements in the <code>dnsname</code> and <code>hostedzoneid</code>
         *        parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first hosted
         * zone in the next group of <code>maxitems</code> hosted zones. Call <code>ListHostedZonesByName</code> again
         * and specify the value of <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the
         * <code>dnsname</code> and <code>hostedzoneid</code> parameters, respectively.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * </p>
         * 
         * @param nextDNSName
         *        If <code>IsTruncated</code> is true, the value of <code>NextDNSName</code> is the name of the first
         *        hosted zone in the next group of <code>maxitems</code> hosted zones. Call
         *        <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
         *        <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
         *        respectively.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextDNSName(String nextDNSName);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code> identifies the
         * first hosted zone in the next group of <code>maxitems</code> hosted zones. Call
         * <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
         * <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
         * respectively.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * </p>
         * 
         * @param nextHostedZoneId
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextHostedZoneId</code>
         *        identifies the first hosted zone in the next group of <code>maxitems</code> hosted zones. Call
         *        <code>ListHostedZonesByName</code> again and specify the value of <code>NextDNSName</code> and
         *        <code>NextHostedZoneId</code> in the <code>dnsname</code> and <code>hostedzoneid</code> parameters,
         *        respectively.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextHostedZoneId(String nextHostedZoneId);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the call to
         * <code>ListHostedZonesByName</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the call to
         *        <code>ListHostedZonesByName</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HostedZone> hostedZones = DefaultSdkAutoConstructList.getInstance();

        private String dnsName;

        private String hostedZoneId;

        private Boolean isTruncated;

        private String nextDNSName;

        private String nextHostedZoneId;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameResponse model) {
            super(model);
            hostedZones(model.hostedZones);
            dnsName(model.dnsName);
            hostedZoneId(model.hostedZoneId);
            isTruncated(model.isTruncated);
            nextDNSName(model.nextDNSName);
            nextHostedZoneId(model.nextHostedZoneId);
            maxItems(model.maxItems);
        }

        public final Collection<HostedZone.Builder> getHostedZones() {
            if (hostedZones instanceof SdkAutoConstructList) {
                return null;
            }
            return hostedZones != null ? hostedZones.stream().map(HostedZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone... hostedZones) {
            hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(Consumer<HostedZone.Builder>... hostedZones) {
            hostedZones(Stream.of(hostedZones).map(c -> HostedZone.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHostedZones(Collection<HostedZone.BuilderImpl> hostedZones) {
            this.hostedZones = HostedZonesCopier.copyFromBuilder(hostedZones);
        }

        public final String getDnsName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextDNSName() {
            return nextDNSName;
        }

        @Override
        public final Builder nextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
            return this;
        }

        public final void setNextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
        }

        public final String getNextHostedZoneId() {
            return nextHostedZoneId;
        }

        @Override
        public final Builder nextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
            return this;
        }

        public final void setNextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHostedZonesByNameResponse build() {
            return new ListHostedZonesByNameResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
