/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.services.route53.model.VPCsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcAssociationAuthorizationsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListVpcAssociationAuthorizationsResponse> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(ListVpcAssociationAuthorizationsResponse.getter(ListVpcAssociationAuthorizationsResponse::hostedZoneId)).setter(ListVpcAssociationAuthorizationsResponse.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVpcAssociationAuthorizationsResponse.getter(ListVpcAssociationAuthorizationsResponse::nextToken)).setter(ListVpcAssociationAuthorizationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<VPC>> VP_CS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VPCs").getter(ListVpcAssociationAuthorizationsResponse.getter(ListVpcAssociationAuthorizationsResponse::vpCs)).setter(ListVpcAssociationAuthorizationsResponse.setter(Builder::vpCs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCs").unmarshallLocationName("VPCs").build(), ListTrait.builder().memberLocationName("VPC").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VPC::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, NEXT_TOKEN_FIELD, VP_CS_FIELD));
    private final String hostedZoneId;
    private final String nextToken;
    private final List<VPC> vpCs;

    private ListVpcAssociationAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.vpCs = builder.vpCs;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasVpCs() {
        return this.vpCs != null && !(this.vpCs instanceof SdkAutoConstructList);
    }

    public List<VPC> vpCs() {
        return this.vpCs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpCs() ? this.vpCs() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcAssociationAuthorizationsResponse)) {
            return false;
        }
        ListVpcAssociationAuthorizationsResponse other = (ListVpcAssociationAuthorizationsResponse)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasVpCs() == other.hasVpCs() && Objects.equals(this.vpCs(), other.vpCs());
    }

    public String toString() {
        return ToString.builder((String)"ListVpcAssociationAuthorizationsResponse").add("HostedZoneId", (Object)this.hostedZoneId()).add("NextToken", (Object)this.nextToken()).add("VPCs", this.hasVpCs() ? this.vpCs() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "VPCs": {
                return Optional.ofNullable(clazz.cast(this.vpCs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVpcAssociationAuthorizationsResponse, T> g) {
        return obj -> g.apply((ListVpcAssociationAuthorizationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String nextToken;
        private List<VPC> vpCs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcAssociationAuthorizationsResponse model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.nextToken(model.nextToken);
            this.vpCs(model.vpCs);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VPC.Builder> getVpCs() {
            if (this.vpCs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpCs != null ? (Collection)this.vpCs.stream().map(VPC::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC ... vpCs) {
            this.vpCs(Arrays.asList(vpCs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(Consumer<VPC.Builder> ... vpCs) {
            this.vpCs(Stream.of(vpCs).map(c -> (VPC)((VPC.Builder)VPC.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        @Override
        public ListVpcAssociationAuthorizationsResponse build() {
            return new ListVpcAssociationAuthorizationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcAssociationAuthorizationsResponse> {
        public Builder hostedZoneId(String var1);

        public Builder nextToken(String var1);

        public Builder vpCs(Collection<VPC> var1);

        public Builder vpCs(VPC ... var1);

        public Builder vpCs(Consumer<VPC.Builder> ... var1);
    }
}

