/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficPoliciesResponse extends Route53Response implements
        ToCopyableBuilder<ListTrafficPoliciesResponse.Builder, ListTrafficPoliciesResponse> {
    private static final SdkField<List<TrafficPolicySummary>> TRAFFIC_POLICY_SUMMARIES_FIELD = SdkField
            .<List<TrafficPolicySummary>> builder(MarshallingType.LIST)
            .memberName("TrafficPolicySummaries")
            .getter(getter(ListTrafficPoliciesResponse::trafficPolicySummaries))
            .setter(setter(Builder::trafficPolicySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicySummaries")
                    .unmarshallLocationName("TrafficPolicySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TrafficPolicySummary")
                            .memberFieldInfo(
                                    SdkField.<TrafficPolicySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficPolicySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TrafficPolicySummary")
                                                    .unmarshallLocationName("TrafficPolicySummary").build()).build()).build())
            .build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(ListTrafficPoliciesResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyIdMarker")
            .getter(getter(ListTrafficPoliciesResponse::trafficPolicyIdMarker))
            .setter(setter(Builder::trafficPolicyIdMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyIdMarker")
                    .unmarshallLocationName("TrafficPolicyIdMarker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListTrafficPoliciesResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_POLICY_SUMMARIES_FIELD, IS_TRUNCATED_FIELD, TRAFFIC_POLICY_ID_MARKER_FIELD, MAX_ITEMS_FIELD));

    private final List<TrafficPolicySummary> trafficPolicySummaries;

    private final Boolean isTruncated;

    private final String trafficPolicyIdMarker;

    private final String maxItems;

    private ListTrafficPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicySummaries = builder.trafficPolicySummaries;
        this.isTruncated = builder.isTruncated;
        this.trafficPolicyIdMarker = builder.trafficPolicyIdMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * Returns true if the TrafficPolicySummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTrafficPolicySummaries() {
        return trafficPolicySummaries != null && !(trafficPolicySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created by
     * the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrafficPolicySummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was
     *         created by the current AWS account.
     */
    public List<TrafficPolicySummary> trafficPolicySummaries() {
        return trafficPolicySummaries;
    }

    /**
     * <p>
     * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you
     * can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request and
     * specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request
     * parameter.
     * </p>
     * 
     * @return A flag that indicates whether there are more traffic policies to be listed. If the response was
     *         truncated, you can get the next group of traffic policies by submitting another
     *         <code>ListTrafficPolicies</code> request and specifying the value of <code>TrafficPolicyIdMarker</code>
     *         in the <code>TrafficPolicyIdMarker</code> request parameter.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID of
     * the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the
     *         ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
     */
    public String trafficPolicyIdMarker() {
        return trafficPolicyIdMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code>
     * request that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>MaxItems</code> parameter in the
     *         <code>ListTrafficPolicies</code> request that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrafficPolicySummaries() ? trafficPolicySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPoliciesResponse)) {
            return false;
        }
        ListTrafficPoliciesResponse other = (ListTrafficPoliciesResponse) obj;
        return hasTrafficPolicySummaries() == other.hasTrafficPolicySummaries()
                && Objects.equals(trafficPolicySummaries(), other.trafficPolicySummaries())
                && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(trafficPolicyIdMarker(), other.trafficPolicyIdMarker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTrafficPoliciesResponse")
                .add("TrafficPolicySummaries", hasTrafficPolicySummaries() ? trafficPolicySummaries() : null)
                .add("IsTruncated", isTruncated()).add("TrafficPolicyIdMarker", trafficPolicyIdMarker())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicySummaries":
            return Optional.ofNullable(clazz.cast(trafficPolicySummaries()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "TrafficPolicyIdMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyIdMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPoliciesResponse, T> g) {
        return obj -> g.apply((ListTrafficPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTrafficPoliciesResponse> {
        /**
         * <p>
         * A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created
         * by the current AWS account.
         * </p>
         * 
         * @param trafficPolicySummaries
         *        A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was
         *        created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicySummaries(Collection<TrafficPolicySummary> trafficPolicySummaries);

        /**
         * <p>
         * A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created
         * by the current AWS account.
         * </p>
         * 
         * @param trafficPolicySummaries
         *        A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was
         *        created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicySummaries(TrafficPolicySummary... trafficPolicySummaries);

        /**
         * <p>
         * A list that contains one <code>TrafficPolicySummary</code> element for each traffic policy that was created
         * by the current AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrafficPolicySummary>.Builder} avoiding the
         * need to create one manually via {@link List<TrafficPolicySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrafficPolicySummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #trafficPolicySummaries(List<TrafficPolicySummary>)}.
         * 
         * @param trafficPolicySummaries
         *        a consumer that will call methods on {@link List<TrafficPolicySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicySummaries(List<TrafficPolicySummary>)
         */
        Builder trafficPolicySummaries(Consumer<TrafficPolicySummary.Builder>... trafficPolicySummaries);

        /**
         * <p>
         * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated,
         * you can get the next group of traffic policies by submitting another <code>ListTrafficPolicies</code> request
         * and specifying the value of <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code>
         * request parameter.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more traffic policies to be listed. If the response was
         *        truncated, you can get the next group of traffic policies by submitting another
         *        <code>ListTrafficPolicies</code> request and specifying the value of
         *        <code>TrafficPolicyIdMarker</code> in the <code>TrafficPolicyIdMarker</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is the ID
         * of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
         * </p>
         * 
         * @param trafficPolicyIdMarker
         *        If the value of <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyIdMarker</code> is
         *        the ID of the first traffic policy in the next group of <code>MaxItems</code> traffic policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyIdMarker(String trafficPolicyIdMarker);

        /**
         * <p>
         * The value that you specified for the <code>MaxItems</code> parameter in the <code>ListTrafficPolicies</code>
         * request that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>MaxItems</code> parameter in the
         *        <code>ListTrafficPolicies</code> request that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<TrafficPolicySummary> trafficPolicySummaries = DefaultSdkAutoConstructList.getInstance();

        private Boolean isTruncated;

        private String trafficPolicyIdMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPoliciesResponse model) {
            super(model);
            trafficPolicySummaries(model.trafficPolicySummaries);
            isTruncated(model.isTruncated);
            trafficPolicyIdMarker(model.trafficPolicyIdMarker);
            maxItems(model.maxItems);
        }

        public final Collection<TrafficPolicySummary.Builder> getTrafficPolicySummaries() {
            if (trafficPolicySummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return trafficPolicySummaries != null ? trafficPolicySummaries.stream().map(TrafficPolicySummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficPolicySummaries(Collection<TrafficPolicySummary> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copy(trafficPolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicySummaries(TrafficPolicySummary... trafficPolicySummaries) {
            trafficPolicySummaries(Arrays.asList(trafficPolicySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicySummaries(Consumer<TrafficPolicySummary.Builder>... trafficPolicySummaries) {
            trafficPolicySummaries(Stream.of(trafficPolicySummaries)
                    .map(c -> TrafficPolicySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrafficPolicySummaries(Collection<TrafficPolicySummary.BuilderImpl> trafficPolicySummaries) {
            this.trafficPolicySummaries = TrafficPolicySummariesCopier.copyFromBuilder(trafficPolicySummaries);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getTrafficPolicyIdMarker() {
            return trafficPolicyIdMarker;
        }

        @Override
        public final Builder trafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
            return this;
        }

        public final void setTrafficPolicyIdMarker(String trafficPolicyIdMarker) {
            this.trafficPolicyIdMarker = trafficPolicyIdMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPoliciesResponse build() {
            return new ListTrafficPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
