/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets information about a specific traffic policy version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrafficPolicyRequest extends Route53Request implements
        ToCopyableBuilder<GetTrafficPolicyRequest.Builder, GetTrafficPolicyRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(GetTrafficPolicyRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version")
            .getter(getter(GetTrafficPolicyRequest::version))
            .setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Version")
                    .unmarshallLocationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_FIELD));

    private final String id;

    private final Integer version;

    private GetTrafficPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ID of the traffic policy that you want to get information about.
     * </p>
     * 
     * @return The ID of the traffic policy that you want to get information about.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The version number of the traffic policy that you want to get information about.
     * </p>
     * 
     * @return The version number of the traffic policy that you want to get information about.
     */
    public final Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficPolicyRequest)) {
            return false;
        }
        GetTrafficPolicyRequest other = (GetTrafficPolicyRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTrafficPolicyRequest").add("Id", id()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrafficPolicyRequest, T> g) {
        return obj -> g.apply((GetTrafficPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, GetTrafficPolicyRequest> {
        /**
         * <p>
         * The ID of the traffic policy that you want to get information about.
         * </p>
         * 
         * @param id
         *        The ID of the traffic policy that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version number of the traffic policy that you want to get information about.
         * </p>
         * 
         * @param version
         *        The version number of the traffic policy that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String id;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficPolicyRequest model) {
            super(model);
            id(model.id);
            version(model.version);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTrafficPolicyRequest build() {
            return new GetTrafficPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
