/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that identifies a hosted zone that a specified Amazon VPC is associated with and the owner of the
 * hosted zone. If there is a value for <code>OwningAccount</code>, there is no value for <code>OwningService</code>,
 * and vice versa.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostedZoneOwner implements SdkPojo, Serializable, ToCopyableBuilder<HostedZoneOwner.Builder, HostedZoneOwner> {
    private static final SdkField<String> OWNING_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwningAccount")
            .getter(getter(HostedZoneOwner::owningAccount))
            .setter(setter(Builder::owningAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwningAccount")
                    .unmarshallLocationName("OwningAccount").build()).build();

    private static final SdkField<String> OWNING_SERVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwningService")
            .getter(getter(HostedZoneOwner::owningService))
            .setter(setter(Builder::owningService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwningService")
                    .unmarshallLocationName("OwningService").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNING_ACCOUNT_FIELD,
            OWNING_SERVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String owningAccount;

    private final String owningService;

    private HostedZoneOwner(BuilderImpl builder) {
        this.owningAccount = builder.owningAccount;
        this.owningService = builder.owningService;
    }

    /**
     * <p>
     * If the hosted zone was created by an AWS account, or was created by an AWS service that creates hosted zones
     * using the current account, <code>OwningAccount</code> contains the account ID of that account. For example, when
     * you use AWS Cloud Map to create a hosted zone, Cloud Map creates the hosted zone using the current AWS account.
     * </p>
     * 
     * @return If the hosted zone was created by an AWS account, or was created by an AWS service that creates hosted
     *         zones using the current account, <code>OwningAccount</code> contains the account ID of that account. For
     *         example, when you use AWS Cloud Map to create a hosted zone, Cloud Map creates the hosted zone using the
     *         current AWS account.
     */
    public final String owningAccount() {
        return owningAccount;
    }

    /**
     * <p>
     * If an AWS service uses its own account to create a hosted zone and associate the specified VPC with that hosted
     * zone, <code>OwningService</code> contains an abbreviation that identifies the service. For example, if Amazon
     * Elastic File System (Amazon EFS) created a hosted zone and associated a VPC with the hosted zone, the value of
     * <code>OwningService</code> is <code>efs.amazonaws.com</code>.
     * </p>
     * 
     * @return If an AWS service uses its own account to create a hosted zone and associate the specified VPC with that
     *         hosted zone, <code>OwningService</code> contains an abbreviation that identifies the service. For
     *         example, if Amazon Elastic File System (Amazon EFS) created a hosted zone and associated a VPC with the
     *         hosted zone, the value of <code>OwningService</code> is <code>efs.amazonaws.com</code>.
     */
    public final String owningService() {
        return owningService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(owningAccount());
        hashCode = 31 * hashCode + Objects.hashCode(owningService());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneOwner)) {
            return false;
        }
        HostedZoneOwner other = (HostedZoneOwner) obj;
        return Objects.equals(owningAccount(), other.owningAccount()) && Objects.equals(owningService(), other.owningService());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostedZoneOwner").add("OwningAccount", owningAccount()).add("OwningService", owningService())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwningAccount":
            return Optional.ofNullable(clazz.cast(owningAccount()));
        case "OwningService":
            return Optional.ofNullable(clazz.cast(owningService()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostedZoneOwner, T> g) {
        return obj -> g.apply((HostedZoneOwner) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostedZoneOwner> {
        /**
         * <p>
         * If the hosted zone was created by an AWS account, or was created by an AWS service that creates hosted zones
         * using the current account, <code>OwningAccount</code> contains the account ID of that account. For example,
         * when you use AWS Cloud Map to create a hosted zone, Cloud Map creates the hosted zone using the current AWS
         * account.
         * </p>
         * 
         * @param owningAccount
         *        If the hosted zone was created by an AWS account, or was created by an AWS service that creates hosted
         *        zones using the current account, <code>OwningAccount</code> contains the account ID of that account.
         *        For example, when you use AWS Cloud Map to create a hosted zone, Cloud Map creates the hosted zone
         *        using the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningAccount(String owningAccount);

        /**
         * <p>
         * If an AWS service uses its own account to create a hosted zone and associate the specified VPC with that
         * hosted zone, <code>OwningService</code> contains an abbreviation that identifies the service. For example, if
         * Amazon Elastic File System (Amazon EFS) created a hosted zone and associated a VPC with the hosted zone, the
         * value of <code>OwningService</code> is <code>efs.amazonaws.com</code>.
         * </p>
         * 
         * @param owningService
         *        If an AWS service uses its own account to create a hosted zone and associate the specified VPC with
         *        that hosted zone, <code>OwningService</code> contains an abbreviation that identifies the service. For
         *        example, if Amazon Elastic File System (Amazon EFS) created a hosted zone and associated a VPC with
         *        the hosted zone, the value of <code>OwningService</code> is <code>efs.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningService(String owningService);
    }

    static final class BuilderImpl implements Builder {
        private String owningAccount;

        private String owningService;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneOwner model) {
            owningAccount(model.owningAccount);
            owningService(model.owningService);
        }

        public final String getOwningAccount() {
            return owningAccount;
        }

        @Override
        public final Builder owningAccount(String owningAccount) {
            this.owningAccount = owningAccount;
            return this;
        }

        public final void setOwningAccount(String owningAccount) {
            this.owningAccount = owningAccount;
        }

        public final String getOwningService() {
            return owningService;
        }

        @Override
        public final Builder owningService(String owningService) {
            this.owningService = owningService;
            return this;
        }

        public final void setOwningService(String owningService) {
            this.owningService = owningService;
        }

        @Override
        public HostedZoneOwner build() {
            return new HostedZoneOwner(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
