/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>TestDNSAnswer</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestDnsAnswerResponse extends Route53Response implements
        ToCopyableBuilder<TestDnsAnswerResponse.Builder, TestDnsAnswerResponse> {
    private static final SdkField<String> NAMESERVER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Nameserver")
            .getter(getter(TestDnsAnswerResponse::nameserver))
            .setter(setter(Builder::nameserver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nameserver")
                    .unmarshallLocationName("Nameserver").build()).build();

    private static final SdkField<String> RECORD_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordName")
            .getter(getter(TestDnsAnswerResponse::recordName))
            .setter(setter(Builder::recordName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordName")
                    .unmarshallLocationName("RecordName").build()).build();

    private static final SdkField<String> RECORD_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordType")
            .getter(getter(TestDnsAnswerResponse::recordTypeAsString))
            .setter(setter(Builder::recordType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordType")
                    .unmarshallLocationName("RecordType").build()).build();

    private static final SdkField<List<String>> RECORD_DATA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RecordData")
            .getter(getter(TestDnsAnswerResponse::recordData))
            .setter(setter(Builder::recordData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordData")
                    .unmarshallLocationName("RecordData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("RecordDataEntry")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("RecordDataEntry").unmarshallLocationName("RecordDataEntry")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> RESPONSE_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResponseCode")
            .getter(getter(TestDnsAnswerResponse::responseCode))
            .setter(setter(Builder::responseCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode")
                    .unmarshallLocationName("ResponseCode").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(TestDnsAnswerResponse::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESERVER_FIELD,
            RECORD_NAME_FIELD, RECORD_TYPE_FIELD, RECORD_DATA_FIELD, RESPONSE_CODE_FIELD, PROTOCOL_FIELD));

    private final String nameserver;

    private final String recordName;

    private final String recordType;

    private final List<String> recordData;

    private final String responseCode;

    private final String protocol;

    private TestDnsAnswerResponse(BuilderImpl builder) {
        super(builder);
        this.nameserver = builder.nameserver;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.recordData = builder.recordData;
        this.responseCode = builder.responseCode;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The Amazon Route 53 name server used to respond to the request.
     * </p>
     * 
     * @return The Amazon Route 53 name server used to respond to the request.
     */
    public final String nameserver() {
        return nameserver;
    }

    /**
     * <p>
     * The name of the resource record set that you submitted a request for.
     * </p>
     * 
     * @return The name of the resource record set that you submitted a request for.
     */
    public final String recordName() {
        return recordName;
    }

    /**
     * <p>
     * The type of the resource record set that you submitted a request for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordType} will
     * return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordTypeAsString}.
     * </p>
     * 
     * @return The type of the resource record set that you submitted a request for.
     * @see RRType
     */
    public final RRType recordType() {
        return RRType.fromValue(recordType);
    }

    /**
     * <p>
     * The type of the resource record set that you submitted a request for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordType} will
     * return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recordTypeAsString}.
     * </p>
     * 
     * @return The type of the resource record set that you submitted a request for.
     * @see RRType
     */
    public final String recordTypeAsString() {
        return recordType;
    }

    /**
     * Returns true if the RecordData property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRecordData() {
        return recordData != null && !(recordData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains values that Amazon Route 53 returned for this resource record set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecordData()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains values that Amazon Route 53 returned for this resource record set.
     */
    public final List<String> recordData() {
        return recordData;
    }

    /**
     * <p>
     * A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>,
     * meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that
     * describes the error. For a list of possible response codes, see <a
     * href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the
     * IANA website.
     * </p>
     * 
     * @return A code that indicates whether the request is valid or not. The most common response code is
     *         <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53
     *         returns a response code that describes the error. For a list of possible response codes, see <a
     *         href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS
     *         RCODES</a> on the IANA website.
     */
    public final String responseCode() {
        return responseCode;
    }

    /**
     * <p>
     * The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>.
     * </p>
     * 
     * @return The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or
     *         <code>TCP</code>.
     */
    public final String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameserver());
        hashCode = 31 * hashCode + Objects.hashCode(recordName());
        hashCode = 31 * hashCode + Objects.hashCode(recordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordData() ? recordData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDnsAnswerResponse)) {
            return false;
        }
        TestDnsAnswerResponse other = (TestDnsAnswerResponse) obj;
        return Objects.equals(nameserver(), other.nameserver()) && Objects.equals(recordName(), other.recordName())
                && Objects.equals(recordTypeAsString(), other.recordTypeAsString()) && hasRecordData() == other.hasRecordData()
                && Objects.equals(recordData(), other.recordData()) && Objects.equals(responseCode(), other.responseCode())
                && Objects.equals(protocol(), other.protocol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestDnsAnswerResponse").add("Nameserver", nameserver()).add("RecordName", recordName())
                .add("RecordType", recordTypeAsString()).add("RecordData", hasRecordData() ? recordData() : null)
                .add("ResponseCode", responseCode()).add("Protocol", protocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Nameserver":
            return Optional.ofNullable(clazz.cast(nameserver()));
        case "RecordName":
            return Optional.ofNullable(clazz.cast(recordName()));
        case "RecordType":
            return Optional.ofNullable(clazz.cast(recordTypeAsString()));
        case "RecordData":
            return Optional.ofNullable(clazz.cast(recordData()));
        case "ResponseCode":
            return Optional.ofNullable(clazz.cast(responseCode()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestDnsAnswerResponse, T> g) {
        return obj -> g.apply((TestDnsAnswerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, TestDnsAnswerResponse> {
        /**
         * <p>
         * The Amazon Route 53 name server used to respond to the request.
         * </p>
         * 
         * @param nameserver
         *        The Amazon Route 53 name server used to respond to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameserver(String nameserver);

        /**
         * <p>
         * The name of the resource record set that you submitted a request for.
         * </p>
         * 
         * @param recordName
         *        The name of the resource record set that you submitted a request for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordName(String recordName);

        /**
         * <p>
         * The type of the resource record set that you submitted a request for.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set that you submitted a request for.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(String recordType);

        /**
         * <p>
         * The type of the resource record set that you submitted a request for.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set that you submitted a request for.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(RRType recordType);

        /**
         * <p>
         * A list that contains values that Amazon Route 53 returned for this resource record set.
         * </p>
         * 
         * @param recordData
         *        A list that contains values that Amazon Route 53 returned for this resource record set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordData(Collection<String> recordData);

        /**
         * <p>
         * A list that contains values that Amazon Route 53 returned for this resource record set.
         * </p>
         * 
         * @param recordData
         *        A list that contains values that Amazon Route 53 returned for this resource record set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordData(String... recordData);

        /**
         * <p>
         * A code that indicates whether the request is valid or not. The most common response code is
         * <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53
         * returns a response code that describes the error. For a list of possible response codes, see <a
         * href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on
         * the IANA website.
         * </p>
         * 
         * @param responseCode
         *        A code that indicates whether the request is valid or not. The most common response code is
         *        <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53
         *        returns a response code that describes the error. For a list of possible response codes, see <a
         *        href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS
         *        RCODES</a> on the IANA website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(String responseCode);

        /**
         * <p>
         * The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>
         * .
         * </p>
         * 
         * @param protocol
         *        The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or
         *        <code>TCP</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private String nameserver;

        private String recordName;

        private String recordType;

        private List<String> recordData = DefaultSdkAutoConstructList.getInstance();

        private String responseCode;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDnsAnswerResponse model) {
            super(model);
            nameserver(model.nameserver);
            recordName(model.recordName);
            recordType(model.recordType);
            recordData(model.recordData);
            responseCode(model.responseCode);
            protocol(model.protocol);
        }

        public final String getNameserver() {
            return nameserver;
        }

        @Override
        public final Builder nameserver(String nameserver) {
            this.nameserver = nameserver;
            return this;
        }

        public final void setNameserver(String nameserver) {
            this.nameserver = nameserver;
        }

        public final String getRecordName() {
            return recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordType() {
            return recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType == null ? null : recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final Collection<String> getRecordData() {
            if (recordData instanceof SdkAutoConstructList) {
                return null;
            }
            return recordData;
        }

        @Override
        public final Builder recordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordData(String... recordData) {
            recordData(Arrays.asList(recordData));
            return this;
        }

        public final void setRecordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
        }

        public final String getResponseCode() {
            return responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public TestDnsAnswerResponse build() {
            return new TestDnsAnswerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
