/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>CreateTrafficPolicyInstance</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficPolicyInstanceResponse extends Route53Response implements
        ToCopyableBuilder<CreateTrafficPolicyInstanceResponse.Builder, CreateTrafficPolicyInstanceResponse> {
    private static final SdkField<TrafficPolicyInstance> TRAFFIC_POLICY_INSTANCE_FIELD = SdkField
            .<TrafficPolicyInstance> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficPolicyInstance")
            .getter(getter(CreateTrafficPolicyInstanceResponse::trafficPolicyInstance))
            .setter(setter(Builder::trafficPolicyInstance))
            .constructor(TrafficPolicyInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstance")
                    .unmarshallLocationName("TrafficPolicyInstance").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateTrafficPolicyInstanceResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_INSTANCE_FIELD,
            LOCATION_FIELD));

    private final TrafficPolicyInstance trafficPolicyInstance;

    private final String location;

    private CreateTrafficPolicyInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstance = builder.trafficPolicyInstance;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains settings for the new traffic policy instance.
     * </p>
     * 
     * @return A complex type that contains settings for the new traffic policy instance.
     */
    public final TrafficPolicyInstance trafficPolicyInstance() {
        return trafficPolicyInstance;
    }

    /**
     * <p>
     * A unique URL that represents a new traffic policy instance.
     * </p>
     * 
     * @return A unique URL that represents a new traffic policy instance.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstance());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyInstanceResponse)) {
            return false;
        }
        CreateTrafficPolicyInstanceResponse other = (CreateTrafficPolicyInstanceResponse) obj;
        return Objects.equals(trafficPolicyInstance(), other.trafficPolicyInstance())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrafficPolicyInstanceResponse").add("TrafficPolicyInstance", trafficPolicyInstance())
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyInstance":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstance()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyInstanceResponse, T> g) {
        return obj -> g.apply((CreateTrafficPolicyInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTrafficPolicyInstanceResponse> {
        /**
         * <p>
         * A complex type that contains settings for the new traffic policy instance.
         * </p>
         * 
         * @param trafficPolicyInstance
         *        A complex type that contains settings for the new traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstance(TrafficPolicyInstance trafficPolicyInstance);

        /**
         * <p>
         * A complex type that contains settings for the new traffic policy instance.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficPolicyInstance.Builder} avoiding the need
         * to create one manually via {@link TrafficPolicyInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficPolicyInstance.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficPolicyInstance(TrafficPolicyInstance)}.
         * 
         * @param trafficPolicyInstance
         *        a consumer that will call methods on {@link TrafficPolicyInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicyInstance(TrafficPolicyInstance)
         */
        default Builder trafficPolicyInstance(Consumer<TrafficPolicyInstance.Builder> trafficPolicyInstance) {
            return trafficPolicyInstance(TrafficPolicyInstance.builder().applyMutation(trafficPolicyInstance).build());
        }

        /**
         * <p>
         * A unique URL that represents a new traffic policy instance.
         * </p>
         * 
         * @param location
         *        A unique URL that represents a new traffic policy instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private TrafficPolicyInstance trafficPolicyInstance;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyInstanceResponse model) {
            super(model);
            trafficPolicyInstance(model.trafficPolicyInstance);
            location(model.location);
        }

        public final TrafficPolicyInstance.Builder getTrafficPolicyInstance() {
            return trafficPolicyInstance != null ? trafficPolicyInstance.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicyInstance(TrafficPolicyInstance trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance;
            return this;
        }

        public final void setTrafficPolicyInstance(TrafficPolicyInstance.BuilderImpl trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance != null ? trafficPolicyInstance.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateTrafficPolicyInstanceResponse build() {
            return new CreateTrafficPolicyInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
