/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A string repesenting the status of DNSSEC signing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DNSSECStatus implements SdkPojo, Serializable, ToCopyableBuilder<DNSSECStatus.Builder, DNSSECStatus> {
    private static final SdkField<String> SERVE_SIGNATURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServeSignature")
            .getter(getter(DNSSECStatus::serveSignature))
            .setter(setter(Builder::serveSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServeSignature")
                    .unmarshallLocationName("ServeSignature").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(DNSSECStatus::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVE_SIGNATURE_FIELD,
            STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serveSignature;

    private final String statusMessage;

    private DNSSECStatus(BuilderImpl builder) {
        this.serveSignature = builder.serveSignature;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * A string that represents the current hosted zone signing status.
     * </p>
     * <p>
     * Status can have one of the following values:
     * </p>
     * <dl>
     * <dt>SIGNING</dt>
     * <dd>
     * <p>
     * DNSSEC signing is enabled for the hosted zone.
     * </p>
     * </dd>
     * <dt>NOT_SIGNING</dt>
     * <dd>
     * <p>
     * DNSSEC signing is not enabled for the hosted zone.
     * </p>
     * </dd>
     * <dt>DELETING</dt>
     * <dd>
     * <p>
     * DNSSEC signing is in the process of being removed for the hosted zone.
     * </p>
     * </dd>
     * <dt>ACTION_NEEDED</dt>
     * <dd>
     * <p>
     * There is a problem with signing in the hosted zone that requires you to take action to resolve. For example, the
     * customer managed customer master key (CMK) might have been deleted, or the permissions for the customer managed
     * CMK might have been changed.
     * </p>
     * </dd>
     * <dt>INTERNAL_FAILURE</dt>
     * <dd>
     * <p>
     * There was an error during a request. Before you can continue to work with DNSSEC signing, including with
     * key-signing keys (KSKs), you must correct the problem by enabling or disabling DNSSEC signing for the hosted
     * zone.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return A string that represents the current hosted zone signing status.</p>
     *         <p>
     *         Status can have one of the following values:
     *         </p>
     *         <dl>
     *         <dt>SIGNING</dt>
     *         <dd>
     *         <p>
     *         DNSSEC signing is enabled for the hosted zone.
     *         </p>
     *         </dd>
     *         <dt>NOT_SIGNING</dt>
     *         <dd>
     *         <p>
     *         DNSSEC signing is not enabled for the hosted zone.
     *         </p>
     *         </dd>
     *         <dt>DELETING</dt>
     *         <dd>
     *         <p>
     *         DNSSEC signing is in the process of being removed for the hosted zone.
     *         </p>
     *         </dd>
     *         <dt>ACTION_NEEDED</dt>
     *         <dd>
     *         <p>
     *         There is a problem with signing in the hosted zone that requires you to take action to resolve. For
     *         example, the customer managed customer master key (CMK) might have been deleted, or the permissions for
     *         the customer managed CMK might have been changed.
     *         </p>
     *         </dd>
     *         <dt>INTERNAL_FAILURE</dt>
     *         <dd>
     *         <p>
     *         There was an error during a request. Before you can continue to work with DNSSEC signing, including with
     *         key-signing keys (KSKs), you must correct the problem by enabling or disabling DNSSEC signing for the
     *         hosted zone.
     *         </p>
     *         </dd>
     */
    public final String serveSignature() {
        return serveSignature;
    }

    /**
     * <p>
     * The status message provided for the following DNSSEC signing status: <code>INTERNAL_FAILURE</code>. The status
     * message includes information about what the problem might be and steps that you can take to correct the issue.
     * </p>
     * 
     * @return The status message provided for the following DNSSEC signing status: <code>INTERNAL_FAILURE</code>. The
     *         status message includes information about what the problem might be and steps that you can take to
     *         correct the issue.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serveSignature());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DNSSECStatus)) {
            return false;
        }
        DNSSECStatus other = (DNSSECStatus) obj;
        return Objects.equals(serveSignature(), other.serveSignature()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DNSSECStatus").add("ServeSignature", serveSignature()).add("StatusMessage", statusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServeSignature":
            return Optional.ofNullable(clazz.cast(serveSignature()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DNSSECStatus, T> g) {
        return obj -> g.apply((DNSSECStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DNSSECStatus> {
        /**
         * <p>
         * A string that represents the current hosted zone signing status.
         * </p>
         * <p>
         * Status can have one of the following values:
         * </p>
         * <dl>
         * <dt>SIGNING</dt>
         * <dd>
         * <p>
         * DNSSEC signing is enabled for the hosted zone.
         * </p>
         * </dd>
         * <dt>NOT_SIGNING</dt>
         * <dd>
         * <p>
         * DNSSEC signing is not enabled for the hosted zone.
         * </p>
         * </dd>
         * <dt>DELETING</dt>
         * <dd>
         * <p>
         * DNSSEC signing is in the process of being removed for the hosted zone.
         * </p>
         * </dd>
         * <dt>ACTION_NEEDED</dt>
         * <dd>
         * <p>
         * There is a problem with signing in the hosted zone that requires you to take action to resolve. For example,
         * the customer managed customer master key (CMK) might have been deleted, or the permissions for the customer
         * managed CMK might have been changed.
         * </p>
         * </dd>
         * <dt>INTERNAL_FAILURE</dt>
         * <dd>
         * <p>
         * There was an error during a request. Before you can continue to work with DNSSEC signing, including with
         * key-signing keys (KSKs), you must correct the problem by enabling or disabling DNSSEC signing for the hosted
         * zone.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param serveSignature
         *        A string that represents the current hosted zone signing status.</p>
         *        <p>
         *        Status can have one of the following values:
         *        </p>
         *        <dl>
         *        <dt>SIGNING</dt>
         *        <dd>
         *        <p>
         *        DNSSEC signing is enabled for the hosted zone.
         *        </p>
         *        </dd>
         *        <dt>NOT_SIGNING</dt>
         *        <dd>
         *        <p>
         *        DNSSEC signing is not enabled for the hosted zone.
         *        </p>
         *        </dd>
         *        <dt>DELETING</dt>
         *        <dd>
         *        <p>
         *        DNSSEC signing is in the process of being removed for the hosted zone.
         *        </p>
         *        </dd>
         *        <dt>ACTION_NEEDED</dt>
         *        <dd>
         *        <p>
         *        There is a problem with signing in the hosted zone that requires you to take action to resolve. For
         *        example, the customer managed customer master key (CMK) might have been deleted, or the permissions
         *        for the customer managed CMK might have been changed.
         *        </p>
         *        </dd>
         *        <dt>INTERNAL_FAILURE</dt>
         *        <dd>
         *        <p>
         *        There was an error during a request. Before you can continue to work with DNSSEC signing, including
         *        with key-signing keys (KSKs), you must correct the problem by enabling or disabling DNSSEC signing for
         *        the hosted zone.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serveSignature(String serveSignature);

        /**
         * <p>
         * The status message provided for the following DNSSEC signing status: <code>INTERNAL_FAILURE</code>. The
         * status message includes information about what the problem might be and steps that you can take to correct
         * the issue.
         * </p>
         * 
         * @param statusMessage
         *        The status message provided for the following DNSSEC signing status: <code>INTERNAL_FAILURE</code>.
         *        The status message includes information about what the problem might be and steps that you can take to
         *        correct the issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String serveSignature;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DNSSECStatus model) {
            serveSignature(model.serveSignature);
            statusMessage(model.statusMessage);
        }

        public final String getServeSignature() {
            return serveSignature;
        }

        @Override
        public final Builder serveSignature(String serveSignature) {
            this.serveSignature = serveSignature;
            return this;
        }

        public final void setServeSignature(String serveSignature) {
            this.serveSignature = serveSignature;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public DNSSECStatus build() {
            return new DNSSECStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
