/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing tags for the specified resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourcesResponse extends Route53Response implements
        ToCopyableBuilder<ListTagsForResourcesResponse.Builder, ListTagsForResourcesResponse> {
    private static final SdkField<List<ResourceTagSet>> RESOURCE_TAG_SETS_FIELD = SdkField
            .<List<ResourceTagSet>> builder(MarshallingType.LIST)
            .memberName("ResourceTagSets")
            .getter(getter(ListTagsForResourcesResponse::resourceTagSets))
            .setter(setter(Builder::resourceTagSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagSets")
                    .unmarshallLocationName("ResourceTagSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ResourceTagSet")
                            .memberFieldInfo(
                                    SdkField.<ResourceTagSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTagSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ResourceTagSet").unmarshallLocationName("ResourceTagSet")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAG_SETS_FIELD));

    private final List<ResourceTagSet> resourceTagSets;

    private ListTagsForResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagSets = builder.resourceTagSets;
    }

    /**
     * Returns true if the ResourceTagSets property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResourceTagSets() {
        return resourceTagSets != null && !(resourceTagSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTagSets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     */
    public final List<ResourceTagSet> resourceTagSets() {
        return resourceTagSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTagSets() ? resourceTagSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesResponse)) {
            return false;
        }
        ListTagsForResourcesResponse other = (ListTagsForResourcesResponse) obj;
        return hasResourceTagSets() == other.hasResourceTagSets() && Objects.equals(resourceTagSets(), other.resourceTagSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForResourcesResponse")
                .add("ResourceTagSets", hasResourceTagSets() ? resourceTagSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTagSets":
            return Optional.ofNullable(clazz.cast(resourceTagSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourcesResponse, T> g) {
        return obj -> g.apply((ListTagsForResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourcesResponse> {
        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets);

        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(ResourceTagSet... resourceTagSets);

        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceTagSet>.Builder} avoiding the need
         * to create one manually via {@link List<ResourceTagSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceTagSet>.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceTagSets(List<ResourceTagSet>)}.
         * 
         * @param resourceTagSets
         *        a consumer that will call methods on {@link List<ResourceTagSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTagSets(List<ResourceTagSet>)
         */
        Builder resourceTagSets(Consumer<ResourceTagSet.Builder>... resourceTagSets);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<ResourceTagSet> resourceTagSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesResponse model) {
            super(model);
            resourceTagSets(model.resourceTagSets);
        }

        public final List<ResourceTagSet.Builder> getResourceTagSets() {
            List<ResourceTagSet.Builder> result = ResourceTagSetListCopier.copyToBuilder(this.resourceTagSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTagSets(Collection<ResourceTagSet.BuilderImpl> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copyFromBuilder(resourceTagSets);
        }

        @Override
        @Transient
        public final Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceTagSets(ResourceTagSet... resourceTagSets) {
            resourceTagSets(Arrays.asList(resourceTagSets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceTagSets(Consumer<ResourceTagSet.Builder>... resourceTagSets) {
            resourceTagSets(Stream.of(resourceTagSets).map(c -> ResourceTagSet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTagsForResourcesResponse build() {
            return new ListTagsForResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
