/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.TrafficPoliciesCopier;
import software.amazon.awssdk.services.route53.model.TrafficPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrafficPolicyVersionsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListTrafficPolicyVersionsResponse> {
    private static final SdkField<List<TrafficPolicy>> TRAFFIC_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrafficPolicies").getter(ListTrafficPolicyVersionsResponse.getter(ListTrafficPolicyVersionsResponse::trafficPolicies)).setter(ListTrafficPolicyVersionsResponse.setter(Builder::trafficPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicies").unmarshallLocationName("TrafficPolicies").build(), ListTrait.builder().memberLocationName("TrafficPolicy").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicy").unmarshallLocationName("TrafficPolicy").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListTrafficPolicyVersionsResponse.getter(ListTrafficPolicyVersionsResponse::isTruncated)).setter(ListTrafficPolicyVersionsResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_VERSION_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficPolicyVersionMarker").getter(ListTrafficPolicyVersionsResponse.getter(ListTrafficPolicyVersionsResponse::trafficPolicyVersionMarker)).setter(ListTrafficPolicyVersionsResponse.setter(Builder::trafficPolicyVersionMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyVersionMarker").unmarshallLocationName("TrafficPolicyVersionMarker").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListTrafficPolicyVersionsResponse.getter(ListTrafficPolicyVersionsResponse::maxItems)).setter(ListTrafficPolicyVersionsResponse.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICIES_FIELD, IS_TRUNCATED_FIELD, TRAFFIC_POLICY_VERSION_MARKER_FIELD, MAX_ITEMS_FIELD));
    private final List<TrafficPolicy> trafficPolicies;
    private final Boolean isTruncated;
    private final String trafficPolicyVersionMarker;
    private final String maxItems;

    private ListTrafficPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicies = builder.trafficPolicies;
        this.isTruncated = builder.isTruncated;
        this.trafficPolicyVersionMarker = builder.trafficPolicyVersionMarker;
        this.maxItems = builder.maxItems;
    }

    public final boolean hasTrafficPolicies() {
        return this.trafficPolicies != null && !(this.trafficPolicies instanceof SdkAutoConstructList);
    }

    public final List<TrafficPolicy> trafficPolicies() {
        return this.trafficPolicies;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String trafficPolicyVersionMarker() {
        return this.trafficPolicyVersionMarker;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrafficPolicies() ? this.trafficPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersionMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyVersionsResponse)) {
            return false;
        }
        ListTrafficPolicyVersionsResponse other = (ListTrafficPolicyVersionsResponse)((Object)obj);
        return this.hasTrafficPolicies() == other.hasTrafficPolicies() && Objects.equals(this.trafficPolicies(), other.trafficPolicies()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.trafficPolicyVersionMarker(), other.trafficPolicyVersionMarker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrafficPolicyVersionsResponse").add("TrafficPolicies", this.hasTrafficPolicies() ? this.trafficPolicies() : null).add("IsTruncated", (Object)this.isTruncated()).add("TrafficPolicyVersionMarker", (Object)this.trafficPolicyVersionMarker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicies": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicies()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "TrafficPolicyVersionMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyVersionMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyVersionsResponse, T> g) {
        return obj -> g.apply((ListTrafficPolicyVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<TrafficPolicy> trafficPolicies = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String trafficPolicyVersionMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyVersionsResponse model) {
            super(model);
            this.trafficPolicies(model.trafficPolicies);
            this.isTruncated(model.isTruncated);
            this.trafficPolicyVersionMarker(model.trafficPolicyVersionMarker);
            this.maxItems(model.maxItems);
        }

        public final List<TrafficPolicy.Builder> getTrafficPolicies() {
            List<TrafficPolicy.Builder> result = TrafficPoliciesCopier.copyToBuilder(this.trafficPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficPolicies(Collection<TrafficPolicy.BuilderImpl> trafficPolicies) {
            this.trafficPolicies = TrafficPoliciesCopier.copyFromBuilder(trafficPolicies);
        }

        @Override
        @Transient
        public final Builder trafficPolicies(Collection<TrafficPolicy> trafficPolicies) {
            this.trafficPolicies = TrafficPoliciesCopier.copy(trafficPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trafficPolicies(TrafficPolicy ... trafficPolicies) {
            this.trafficPolicies(Arrays.asList(trafficPolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trafficPolicies(Consumer<TrafficPolicy.Builder> ... trafficPolicies) {
            this.trafficPolicies(Stream.of(trafficPolicies).map(c -> (TrafficPolicy)((TrafficPolicy.Builder)TrafficPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        @Transient
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getTrafficPolicyVersionMarker() {
            return this.trafficPolicyVersionMarker;
        }

        public final void setTrafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
        }

        @Override
        @Transient
        public final Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        @Transient
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ListTrafficPolicyVersionsResponse build() {
            return new ListTrafficPolicyVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrafficPolicyVersionsResponse> {
        public Builder trafficPolicies(Collection<TrafficPolicy> var1);

        public Builder trafficPolicies(TrafficPolicy ... var1);

        public Builder trafficPolicies(Consumer<TrafficPolicy.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder trafficPolicyVersionMarker(String var1);

        public Builder maxItems(String var1);
    }
}

