/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contain the response to a <code>GetHostedZone</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHostedZoneResponse extends Route53Response implements
        ToCopyableBuilder<GetHostedZoneResponse.Builder, GetHostedZoneResponse> {
    private static final SdkField<HostedZone> HOSTED_ZONE_FIELD = SdkField
            .<HostedZone> builder(MarshallingType.SDK_POJO)
            .memberName("HostedZone")
            .getter(getter(GetHostedZoneResponse::hostedZone))
            .setter(setter(Builder::hostedZone))
            .constructor(HostedZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone")
                    .unmarshallLocationName("HostedZone").build()).build();

    private static final SdkField<DelegationSet> DELEGATION_SET_FIELD = SdkField
            .<DelegationSet> builder(MarshallingType.SDK_POJO)
            .memberName("DelegationSet")
            .getter(getter(GetHostedZoneResponse::delegationSet))
            .setter(setter(Builder::delegationSet))
            .constructor(DelegationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet")
                    .unmarshallLocationName("DelegationSet").build()).build();

    private static final SdkField<List<VPC>> VP_CS_FIELD = SdkField
            .<List<VPC>> builder(MarshallingType.LIST)
            .memberName("VPCs")
            .getter(getter(GetHostedZoneResponse::vpCs))
            .setter(setter(Builder::vpCs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCs")
                    .unmarshallLocationName("VPCs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VPC")
                            .memberFieldInfo(
                                    SdkField.<VPC> builder(MarshallingType.SDK_POJO)
                                            .constructor(VPC::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VPC").unmarshallLocationName("VPC").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_FIELD,
            DELEGATION_SET_FIELD, VP_CS_FIELD));

    private final HostedZone hostedZone;

    private final DelegationSet delegationSet;

    private final List<VPC> vpCs;

    private GetHostedZoneResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZone = builder.hostedZone;
        this.delegationSet = builder.delegationSet;
        this.vpCs = builder.vpCs;
    }

    /**
     * <p>
     * A complex type that contains general information about the specified hosted zone.
     * </p>
     * 
     * @return A complex type that contains general information about the specified hosted zone.
     */
    public final HostedZone hostedZone() {
        return hostedZone;
    }

    /**
     * <p>
     * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
     * </p>
     * 
     * @return A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
     */
    public final DelegationSet delegationSet() {
        return delegationSet;
    }

    /**
     * Returns true if the VPCs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasVpCs() {
        return vpCs != null && !(vpCs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpCs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains information about the VPCs that are associated with the specified hosted
     *         zone.
     */
    public final List<VPC> vpCs() {
        return vpCs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpCs() ? vpCs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneResponse)) {
            return false;
        }
        GetHostedZoneResponse other = (GetHostedZoneResponse) obj;
        return Objects.equals(hostedZone(), other.hostedZone()) && Objects.equals(delegationSet(), other.delegationSet())
                && hasVpCs() == other.hasVpCs() && Objects.equals(vpCs(), other.vpCs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHostedZoneResponse").add("HostedZone", hostedZone()).add("DelegationSet", delegationSet())
                .add("VPCs", hasVpCs() ? vpCs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZone":
            return Optional.ofNullable(clazz.cast(hostedZone()));
        case "DelegationSet":
            return Optional.ofNullable(clazz.cast(delegationSet()));
        case "VPCs":
            return Optional.ofNullable(clazz.cast(vpCs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHostedZoneResponse, T> g) {
        return obj -> g.apply((GetHostedZoneResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetHostedZoneResponse> {
        /**
         * <p>
         * A complex type that contains general information about the specified hosted zone.
         * </p>
         * 
         * @param hostedZone
         *        A complex type that contains general information about the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZone(HostedZone hostedZone);

        /**
         * <p>
         * A complex type that contains general information about the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link HostedZone.Builder} avoiding the need to create
         * one manually via {@link HostedZone#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZone.Builder#build()} is called immediately and its result
         * is passed to {@link #hostedZone(HostedZone)}.
         * 
         * @param hostedZone
         *        a consumer that will call methods on {@link HostedZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZone(HostedZone)
         */
        default Builder hostedZone(Consumer<HostedZone.Builder> hostedZone) {
            return hostedZone(HostedZone.builder().applyMutation(hostedZone).build());
        }

        /**
         * <p>
         * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link DelegationSet.Builder} avoiding the need to
         * create one manually via {@link DelegationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link DelegationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #delegationSet(DelegationSet)}.
         * 
         * @param delegationSet
         *        a consumer that will call methods on {@link DelegationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegationSet(DelegationSet)
         */
        default Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return delegationSet(DelegationSet.builder().applyMutation(delegationSet).build());
        }

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        A complex type that contains information about the VPCs that are associated with the specified hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(Collection<VPC> vpCs);

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        A complex type that contains information about the VPCs that are associated with the specified hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(VPC... vpCs);

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VPC>.Builder} avoiding the need to create
         * one manually via {@link List<VPC>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VPC>.Builder#build()} is called immediately and its result
         * is passed to {@link #vpCs(List<VPC>)}.
         * 
         * @param vpCs
         *        a consumer that will call methods on {@link List<VPC>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpCs(List<VPC>)
         */
        Builder vpCs(Consumer<VPC.Builder>... vpCs);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private HostedZone hostedZone;

        private DelegationSet delegationSet;

        private List<VPC> vpCs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneResponse model) {
            super(model);
            hostedZone(model.hostedZone);
            delegationSet(model.delegationSet);
            vpCs(model.vpCs);
        }

        public final HostedZone.Builder getHostedZone() {
            return hostedZone != null ? hostedZone.toBuilder() : null;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        @Override
        @Transient
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final DelegationSet.Builder getDelegationSet() {
            return delegationSet != null ? delegationSet.toBuilder() : null;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        @Override
        @Transient
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final List<VPC.Builder> getVpCs() {
            List<VPC.Builder> result = VPCsCopier.copyToBuilder(this.vpCs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        @Override
        @Transient
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpCs(VPC... vpCs) {
            vpCs(Arrays.asList(vpCs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpCs(Consumer<VPC.Builder>... vpCs) {
            vpCs(Stream.of(vpCs).map(c -> VPC.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetHostedZoneResponse build() {
            return new GetHostedZoneResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
