/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckConfig.Builder, HealthCheckConfig> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IPAddress")
            .getter(getter(HealthCheckConfig::ipAddress))
            .setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress")
                    .unmarshallLocationName("IPAddress").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Port")
            .getter(getter(HealthCheckConfig::port))
            .setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port")
                    .unmarshallLocationName("Port").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(HealthCheckConfig::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<String> RESOURCE_PATH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourcePath")
            .getter(getter(HealthCheckConfig::resourcePath))
            .setter(setter(Builder::resourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePath")
                    .unmarshallLocationName("ResourcePath").build()).build();

    private static final SdkField<String> FULLY_QUALIFIED_DOMAIN_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FullyQualifiedDomainName")
            .getter(getter(HealthCheckConfig::fullyQualifiedDomainName))
            .setter(setter(Builder::fullyQualifiedDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullyQualifiedDomainName")
                    .unmarshallLocationName("FullyQualifiedDomainName").build()).build();

    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SearchString")
            .getter(getter(HealthCheckConfig::searchString))
            .setter(setter(Builder::searchString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString")
                    .unmarshallLocationName("SearchString").build()).build();

    private static final SdkField<Integer> REQUEST_INTERVAL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RequestInterval")
            .getter(getter(HealthCheckConfig::requestInterval))
            .setter(setter(Builder::requestInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestInterval")
                    .unmarshallLocationName("RequestInterval").build()).build();

    private static final SdkField<Integer> FAILURE_THRESHOLD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailureThreshold")
            .getter(getter(HealthCheckConfig::failureThreshold))
            .setter(setter(Builder::failureThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureThreshold")
                    .unmarshallLocationName("FailureThreshold").build()).build();

    private static final SdkField<Boolean> MEASURE_LATENCY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MeasureLatency")
            .getter(getter(HealthCheckConfig::measureLatency))
            .setter(setter(Builder::measureLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureLatency")
                    .unmarshallLocationName("MeasureLatency").build()).build();

    private static final SdkField<Boolean> INVERTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inverted")
            .getter(getter(HealthCheckConfig::inverted))
            .setter(setter(Builder::inverted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverted")
                    .unmarshallLocationName("Inverted").build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled")
            .getter(getter(HealthCheckConfig::disabled))
            .setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled")
                    .unmarshallLocationName("Disabled").build()).build();

    private static final SdkField<Integer> HEALTH_THRESHOLD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthThreshold")
            .getter(getter(HealthCheckConfig::healthThreshold))
            .setter(setter(Builder::healthThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthThreshold")
                    .unmarshallLocationName("HealthThreshold").build()).build();

    private static final SdkField<List<String>> CHILD_HEALTH_CHECKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ChildHealthChecks")
            .getter(getter(HealthCheckConfig::childHealthChecks))
            .setter(setter(Builder::childHealthChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildHealthChecks")
                    .unmarshallLocationName("ChildHealthChecks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ChildHealthCheck")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ChildHealthCheck").unmarshallLocationName("ChildHealthCheck")
                                                    .build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_SNI_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableSNI")
            .getter(getter(HealthCheckConfig::enableSNI))
            .setter(setter(Builder::enableSNI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSNI")
                    .unmarshallLocationName("EnableSNI").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Regions")
            .getter(getter(HealthCheckConfig::regionsAsStrings))
            .setter(setter(Builder::regionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions")
                    .unmarshallLocationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Region")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Region").unmarshallLocationName("Region").build()).build())
                            .build()).build();

    private static final SdkField<AlarmIdentifier> ALARM_IDENTIFIER_FIELD = SdkField
            .<AlarmIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("AlarmIdentifier")
            .getter(getter(HealthCheckConfig::alarmIdentifier))
            .setter(setter(Builder::alarmIdentifier))
            .constructor(AlarmIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmIdentifier")
                    .unmarshallLocationName("AlarmIdentifier").build()).build();

    private static final SdkField<String> INSUFFICIENT_DATA_HEALTH_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InsufficientDataHealthStatus")
            .getter(getter(HealthCheckConfig::insufficientDataHealthStatusAsString))
            .setter(setter(Builder::insufficientDataHealthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientDataHealthStatus")
                    .unmarshallLocationName("InsufficientDataHealthStatus").build()).build();

    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlArn")
            .getter(getter(HealthCheckConfig::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn")
                    .unmarshallLocationName("RoutingControlArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, PORT_FIELD,
            TYPE_FIELD, RESOURCE_PATH_FIELD, FULLY_QUALIFIED_DOMAIN_NAME_FIELD, SEARCH_STRING_FIELD, REQUEST_INTERVAL_FIELD,
            FAILURE_THRESHOLD_FIELD, MEASURE_LATENCY_FIELD, INVERTED_FIELD, DISABLED_FIELD, HEALTH_THRESHOLD_FIELD,
            CHILD_HEALTH_CHECKS_FIELD, ENABLE_SNI_FIELD, REGIONS_FIELD, ALARM_IDENTIFIER_FIELD,
            INSUFFICIENT_DATA_HEALTH_STATUS_FIELD, ROUTING_CONTROL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final Integer port;

    private final String type;

    private final String resourcePath;

    private final String fullyQualifiedDomainName;

    private final String searchString;

    private final Integer requestInterval;

    private final Integer failureThreshold;

    private final Boolean measureLatency;

    private final Boolean inverted;

    private final Boolean disabled;

    private final Integer healthThreshold;

    private final List<String> childHealthChecks;

    private final Boolean enableSNI;

    private final List<String> regions;

    private final AlarmIdentifier alarmIdentifier;

    private final String insufficientDataHealthStatus;

    private final String routingControlArn;

    private HealthCheckConfig(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.type = builder.type;
        this.resourcePath = builder.resourcePath;
        this.fullyQualifiedDomainName = builder.fullyQualifiedDomainName;
        this.searchString = builder.searchString;
        this.requestInterval = builder.requestInterval;
        this.failureThreshold = builder.failureThreshold;
        this.measureLatency = builder.measureLatency;
        this.inverted = builder.inverted;
        this.disabled = builder.disabled;
        this.healthThreshold = builder.healthThreshold;
        this.childHealthChecks = builder.childHealthChecks;
        this.enableSNI = builder.enableSNI;
        this.regions = builder.regions;
        this.alarmIdentifier = builder.alarmIdentifier;
        this.insufficientDataHealthStatus = builder.insufficientDataHealthStatus;
        this.routingControlArn = builder.routingControlArn;
    }

    /**
     * <p>
     * The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on. If you
     * don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that
     * you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in
     * <code>RequestInterval</code>. Using an IP address returned by DNS, Route 53 then checks the health of the
     * endpoint.
     * </p>
     * <p>
     * Use one of the following formats for the value of <code>IPAddress</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example,
     * <code>192.0.2.44</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example,
     * <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC
     * 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your
     * EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of
     * your instance will never change.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName"
     * >FullyQualifiedDomainName</a>.
     * </p>
     * <p>
     * Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private,
     * non-routable, or multicast ranges. For more information about IP addresses for which you can't create health
     * checks, see the following documents:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When the value of <code>Type</code> is <code>CALCULATED</code> or <code>CLOUDWATCH_METRIC</code>, omit
     * <code>IPAddress</code>.
     * </p>
     * 
     * @return The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on. If
     *         you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain
     *         name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in
     *         <code>RequestInterval</code>. Using an IP address returned by DNS, Route 53 then checks the health of the
     *         endpoint.</p>
     *         <p>
     *         Use one of the following formats for the value of <code>IPAddress</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example,
     *         <code>192.0.2.44</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example,
     *         <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in
     *         RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with
     *         your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the
     *         IP address of your instance will never change.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName"
     *         >FullyQualifiedDomainName</a>.
     *         </p>
     *         <p>
     *         Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private,
     *         non-routable, or multicast ranges. For more information about IP addresses for which you can't create
     *         health checks, see the following documents:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address
     *         Space</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When the value of <code>Type</code> is <code>CALCULATED</code> or <code>CLOUDWATCH_METRIC</code>, omit
     *         <code>IPAddress</code>.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The port on the endpoint that you want Amazon Route 53 to perform health checks on.
     * </p>
     * <note>
     * <p>
     * Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of
     * <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.
     * </p>
     * </note>
     * 
     * @return The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p> <note>
     *         <p>
     *         Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of
     *         <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.
     *         </p>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
     * endpoint is healthy.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>Type</code> after you create a health check.
     * </p>
     * </important>
     * <p>
     * You can create the following types of health checks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * <important>
     * <p>
     * If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS v1.0 or
     * later.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
     * request and searches the first 5,120 bytes of the response body for the string that you specify in
     * <code>SearchString</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
     * <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that you
     * specify in <code>SearchString</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TCP</b>: Route 53 tries to establish a TCP connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the alarm is
     * <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>, the health check is
     * considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is
     * <code>OK</code> or <code>ALARM</code>, the health check status depends on the setting for
     * <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>, or
     * <code>LastKnownStatus</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up the number
     * of health checks that Route 53 health checkers consider to be healthy and compares that number with the value of
     * <code>HealthThreshold</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller routing
     * control. If the routing control state is <code>ON</code>, the health check is considered healthy. If the state is
     * <code>OFF</code>, the health check is considered unhealthy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of health check that you want to create, which indicates how Amazon Route 53 determines whether
     *         an endpoint is healthy.</p> <important>
     *         <p>
     *         You can't change the value of <code>Type</code> after you create a health check.
     *         </p>
     *         </important>
     *         <p>
     *         You can create the following types of health checks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS v1.0
     *         or later.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
     *         HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in
     *         <code>SearchString</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
     *         <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that
     *         you specify in <code>SearchString</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TCP</b>: Route 53 tries to establish a TCP connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the
     *         alarm is <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>, the
     *         health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the
     *         state is <code>OK</code> or <code>ALARM</code>, the health check status depends on the setting for
     *         <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>, or
     *         <code>LastKnownStatus</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up the
     *         number of health checks that Route 53 health checkers consider to be healthy and compares that number
     *         with the value of <code>HealthThreshold</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller
     *         routing control. If the routing control state is <code>ON</code>, the health check is considered healthy.
     *         If the state is <code>OFF</code>, the health check is considered unhealthy.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
     *         Guide</i>.
     * @see HealthCheckType
     */
    public final HealthCheckType type() {
        return HealthCheckType.fromValue(type);
    }

    /**
     * <p>
     * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
     * endpoint is healthy.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>Type</code> after you create a health check.
     * </p>
     * </important>
     * <p>
     * You can create the following types of health checks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request and
     * waits for an HTTP status code of 200 or greater and less than 400.
     * </p>
     * <important>
     * <p>
     * If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS v1.0 or
     * later.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
     * request and searches the first 5,120 bytes of the response body for the string that you specify in
     * <code>SearchString</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
     * <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that you
     * specify in <code>SearchString</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TCP</b>: Route 53 tries to establish a TCP connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the alarm is
     * <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>, the health check is
     * considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is
     * <code>OK</code> or <code>ALARM</code>, the health check status depends on the setting for
     * <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>, or
     * <code>LastKnownStatus</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up the number
     * of health checks that Route 53 health checkers consider to be healthy and compares that number with the value of
     * <code>HealthThreshold</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller routing
     * control. If the routing control state is <code>ON</code>, the health check is considered healthy. If the state is
     * <code>OFF</code>, the health check is considered unhealthy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HealthCheckType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of health check that you want to create, which indicates how Amazon Route 53 determines whether
     *         an endpoint is healthy.</p> <important>
     *         <p>
     *         You can't change the value of <code>Type</code> after you create a health check.
     *         </p>
     *         </important>
     *         <p>
     *         You can create the following types of health checks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
     *         request and waits for an HTTP status code of 200 or greater and less than 400.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS v1.0
     *         or later.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
     *         HTTP request and searches the first 5,120 bytes of the response body for the string that you specify in
     *         <code>SearchString</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
     *         <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that
     *         you specify in <code>SearchString</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TCP</b>: Route 53 tries to establish a TCP connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the
     *         alarm is <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>, the
     *         health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the
     *         state is <code>OK</code> or <code>ALARM</code>, the health check status depends on the setting for
     *         <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>, or
     *         <code>LastKnownStatus</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up the
     *         number of health checks that Route 53 health checkers consider to be healthy and compares that number
     *         with the value of <code>HealthThreshold</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller
     *         routing control. If the routing control state is <code>ON</code>, the health check is considered healthy.
     *         If the state is <code>OFF</code>, the health check is considered unhealthy.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
     *         Guide</i>.
     * @see HealthCheckType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The path, if any, that you want Amazon Route 53 to request when performing health checks. The path can be any
     * value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for
     * example, the file /docs/route53-health-check.html. You can also include query string parameters, for example,
     * <code>/welcome.html?language=jp&amp;login=y</code>.
     * </p>
     * 
     * @return The path, if any, that you want Amazon Route 53 to request when performing health checks. The path can be
     *         any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is
     *         healthy, for example, the file /docs/route53-health-check.html. You can also include query string
     *         parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code>.
     */
    public final String resourcePath() {
        return resourcePath;
    }

    /**
     * <p>
     * Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.
     * </p>
     * <p>
     * <b>If you specify a value for</b> <code>IPAddress</code>:
     * </p>
     * <p>
     * Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of
     * <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health
     * checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform
     * health checks.
     * </p>
     * <p>
     * When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or
     * <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
     * <code>FullyQualifiedDomainName</code> to the endpoint in the Host header.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or
     * <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
     * <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>,
     * Route 53 passes <code>FullyQualifiedDomainName:Port</code> to the endpoint in the <code>Host</code> header.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of
     * <code>IPAddress</code> in the <code>Host</code> header in each of the preceding cases.
     * </p>
     * <p>
     * <b>If you don't specify a value for <code>IPAddress</code> </b>:
     * </p>
     * <p>
     * Route 53 sends a DNS request to the domain that you specify for <code>FullyQualifiedDomainName</code> at the
     * interval that you specify for <code>RequestInterval</code>. Using an IPv4 address that DNS returns, Route 53 then
     * checks the health of the endpoint.
     * </p>
     * <note>
     * <p>
     * If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the
     * endpoint. If there's no resource record set with a type of A for the name that you specify for
     * <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.
     * </p>
     * </note>
     * <p>
     * If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify
     * the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check
     * for each endpoint. For example, create a health check for each HTTP server that is serving content for
     * www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name of the server
     * (such as us-east-2-www.example.com), not the name of the resource record sets (www.example.com).
     * </p>
     * <important>
     * <p>
     * In this configuration, if you create a health check for which the value of <code>FullyQualifiedDomainName</code>
     * matches the name of the resource record sets and you then associate the health check with those resource record
     * sets, health check results will be unpredictable.
     * </p>
     * </important>
     * <p>
     * In addition, if the value that you specify for <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>,
     * <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of
     * <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value for
     * <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a
     * <code>Host</code> header.
     * </p>
     * 
     * @return Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p>
     *         <p>
     *         <b>If you specify a value for</b> <code>IPAddress</code>:
     *         </p>
     *         <p>
     *         Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of
     *         <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP
     *         health checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53
     *         to perform health checks.
     *         </p>
     *         <p>
     *         When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or
     *         <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
     *         <code>FullyQualifiedDomainName</code> to the endpoint in the Host header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or
     *         <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
     *         <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify another value for <code>Port</code> and any value except <code>TCP</code> for
     *         <code>Type</code>, Route 53 passes <code>FullyQualifiedDomainName:Port</code> to the endpoint in the
     *         <code>Host</code> header.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of
     *         <code>IPAddress</code> in the <code>Host</code> header in each of the preceding cases.
     *         </p>
     *         <p>
     *         <b>If you don't specify a value for <code>IPAddress</code> </b>:
     *         </p>
     *         <p>
     *         Route 53 sends a DNS request to the domain that you specify for <code>FullyQualifiedDomainName</code> at
     *         the interval that you specify for <code>RequestInterval</code>. Using an IPv4 address that DNS returns,
     *         Route 53 then checks the health of the endpoint.
     *         </p>
     *         <note>
     *         <p>
     *         If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to
     *         the endpoint. If there's no resource record set with a type of A for the name that you specify for
     *         <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.
     *         </p>
     *         </note>
     *         <p>
     *         If you want to check the health of weighted, latency, or failover resource record sets and you choose to
     *         specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a
     *         separate health check for each endpoint. For example, create a health check for each HTTP server that is
     *         serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the
     *         domain name of the server (such as us-east-2-www.example.com), not the name of the resource record sets
     *         (www.example.com).
     *         </p>
     *         <important>
     *         <p>
     *         In this configuration, if you create a health check for which the value of
     *         <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate
     *         the health check with those resource record sets, health check results will be unpredictable.
     *         </p>
     *         </important>
     *         <p>
     *         In addition, if the value that you specify for <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of
     *         <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a
     *         value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't
     *         pass a <code>Host</code> header.
     */
    public final String fullyQualifiedDomainName() {
        return fullyQualifiedDomainName;
    }

    /**
     * <p>
     * If the value of Type is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want
     * Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the
     * response body, Route 53 considers the resource healthy.
     * </p>
     * <p>
     * Route 53 considers case when searching for <code>SearchString</code> in the response body.
     * </p>
     * 
     * @return If the value of Type is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you
     *         want Amazon Route 53 to search for in the response body from the specified resource. If the string
     *         appears in the response body, Route 53 considers the resource healthy.</p>
     *         <p>
     *         Route 53 considers case when searching for <code>SearchString</code> in the response body.
     */
    public final String searchString() {
        return searchString;
    }

    /**
     * <p>
     * The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that
     * it sends the next health check request. Each Route 53 health checker makes requests at this interval.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>RequestInterval</code> after you create a health check.
     * </p>
     * </important>
     * <p>
     * If you don't specify a value for <code>RequestInterval</code>, the default value is <code>30</code> seconds.
     * </p>
     * 
     * @return The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the
     *         time that it sends the next health check request. Each Route 53 health checker makes requests at this
     *         interval.</p> <important>
     *         <p>
     *         You can't change the value of <code>RequestInterval</code> after you create a health check.
     *         </p>
     *         </important>
     *         <p>
     *         If you don't specify a value for <code>RequestInterval</code>, the default value is <code>30</code>
     *         seconds.
     */
    public final Integer requestInterval() {
        return requestInterval;
    }

    /**
     * <p>
     * The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the
     * current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href=
     * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How
     * Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.
     * </p>
     * 
     * @return The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change
     *         the current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
     *         >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
     *         Guide</i>.</p>
     *         <p>
     *         If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.
     */
    public final Integer failureThreshold() {
        return failureThreshold;
    }

    /**
     * <p>
     * Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple Amazon Web
     * Services regions and your endpoint, and to display CloudWatch latency graphs on the <b>Health Checks</b> page in
     * the Route 53 console.
     * </p>
     * <important>
     * <p>
     * You can't change the value of <code>MeasureLatency</code> after you create a health check.
     * </p>
     * </important>
     * 
     * @return Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple
     *         Amazon Web Services regions and your endpoint, and to display CloudWatch latency graphs on the <b>Health
     *         Checks</b> page in the Route 53 console.</p> <important>
     *         <p>
     *         You can't change the value of <code>MeasureLatency</code> after you create a health check.
     *         </p>
     */
    public final Boolean measureLatency() {
        return measureLatency;
    }

    /**
     * <p>
     * Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a
     * health check unhealthy when it otherwise would be considered healthy.
     * </p>
     * 
     * @return Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider
     *         a health check unhealthy when it otherwise would be considered healthy.
     */
    public final Boolean inverted() {
        return inverted;
    }

    /**
     * <p>
     * Stops Route 53 from performing health checks. When you disable a health check, here's what happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your application,
     * server, or other resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding CloudWatch
     * metrics.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you
     * configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop
     * routing traffic to a resource, change the value of <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted"
     * >Inverted</a>.
     * </p>
     * <p>
     * Charges for a health check still apply when the health check is disabled. For more information, see <a
     * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
     * </p>
     * 
     * @return Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your
     *         application, server, or other resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding
     *         CloudWatch metrics.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After you disable a health check, Route 53 considers the status of the health check to always be healthy.
     *         If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If
     *         you want to stop routing traffic to a resource, change the value of <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted"
     *         >Inverted</a>.
     *         </p>
     *         <p>
     *         Charges for a health check still apply when the health check is disabled. For more information, see <a
     *         href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * <p>
     * The number of child health checks that are associated with a <code>CALCULATED</code> health check that Amazon
     * Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To specify
     * the child health checks that you want to associate with a <code>CALCULATED</code> health check, use the <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks"
     * >ChildHealthChecks</a> element.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify a number greater than the number of child health checks, Route 53 always considers this health
     * check to be unhealthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>0</code>, Route 53 always considers this health check to be healthy.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of child health checks that are associated with a <code>CALCULATED</code> health check that
     *         Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered
     *         healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code>
     *         health check, use the <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks"
     *         >ChildHealthChecks</a> element.</p>
     *         <p>
     *         Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify a number greater than the number of child health checks, Route 53 always considers this
     *         health check to be unhealthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>0</code>, Route 53 always considers this health check to be healthy.
     *         </p>
     *         </li>
     */
    public final Integer healthThreshold() {
        return healthThreshold;
    }

    /**
     * Returns true if the ChildHealthChecks property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasChildHealthChecks() {
        return childHealthChecks != null && !(childHealthChecks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element for each
     * health check that you want to associate with a <code>CALCULATED</code> health check.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChildHealthChecks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element
     *         for each health check that you want to associate with a <code>CALCULATED</code> health check.
     */
    public final List<String> childHealthChecks() {
        return childHealthChecks;
    }

    /**
     * <p>
     * Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the
     * endpoint in the <code>client_hello</code> message during TLS negotiation. This allows the endpoint to respond to
     * <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.
     * </p>
     * <p>
     * Some endpoints require that <code>HTTPS</code> requests include the host name in the <code>client_hello</code>
     * message. If you don't enable SNI, the status of the health check will be <code>SSL alert handshake_failure</code>
     * . A health check can also have that status for other reasons. If SNI is enabled and you're still getting the
     * error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.
     * </p>
     * <p>
     * The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and
     * possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the
     * certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the endpoint
     * responds to the <code>client_hello</code> message with a certificate that does not include the domain name that
     * you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the second
     * attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code>
     * message.
     * </p>
     * 
     * @return Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to
     *         the endpoint in the <code>client_hello</code> message during TLS negotiation. This allows the endpoint to
     *         respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p>
     *         <p>
     *         Some endpoints require that <code>HTTPS</code> requests include the host name in the
     *         <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be
     *         <code>SSL alert handshake_failure</code>. A health check can also have that status for other reasons. If
     *         SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and
     *         confirm that your certificate is valid.
     *         </p>
     *         <p>
     *         The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and
     *         possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the
     *         certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the
     *         endpoint responds to the <code>client_hello</code> message with a certificate that does not include the
     *         domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the
     *         handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from
     *         the <code>client_hello</code> message.
     */
    public final Boolean enableSNI() {
        return enableSNI;
    }

    /**
     * <p>
     * A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route 53
     * health checkers to check the specified endpoint.
     * </p>
     * <p>
     * If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the regions
     * that are listed under <b>Valid Values</b>.
     * </p>
     * <p>
     * If you update a health check to remove a region that has been performing health checks, Route 53 will briefly
     * continue to perform checks from that region to ensure that some health checkers are always checking the endpoint
     * (for example, if you replace three regions with four different regions).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains one <code>Region</code> element for each region from which you want Amazon
     *         Route 53 health checkers to check the specified endpoint.</p>
     *         <p>
     *         If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the
     *         regions that are listed under <b>Valid Values</b>.
     *         </p>
     *         <p>
     *         If you update a health check to remove a region that has been performing health checks, Route 53 will
     *         briefly continue to perform checks from that region to ensure that some health checkers are always
     *         checking the endpoint (for example, if you replace three regions with four different regions).
     */
    public final List<HealthCheckRegion> regions() {
        return HealthCheckRegionListCopier.copyStringToEnum(regions);
    }

    /**
     * Returns true if the Regions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route 53
     * health checkers to check the specified endpoint.
     * </p>
     * <p>
     * If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the regions
     * that are listed under <b>Valid Values</b>.
     * </p>
     * <p>
     * If you update a health check to remove a region that has been performing health checks, Route 53 will briefly
     * continue to perform checks from that region to ensure that some health checkers are always checking the endpoint
     * (for example, if you replace three regions with four different regions).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A complex type that contains one <code>Region</code> element for each region from which you want Amazon
     *         Route 53 health checkers to check the specified endpoint.</p>
     *         <p>
     *         If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the
     *         regions that are listed under <b>Valid Values</b>.
     *         </p>
     *         <p>
     *         If you update a health check to remove a region that has been performing health checks, Route 53 will
     *         briefly continue to perform checks from that region to ensure that some health checkers are always
     *         checking the endpoint (for example, if you replace three regions with four different regions).
     */
    public final List<String> regionsAsStrings() {
        return regions;
    }

    /**
     * <p>
     * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to
     * determine whether the specified health check is healthy.
     * </p>
     * 
     * @return A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use
     *         to determine whether the specified health check is healthy.
     */
    public final AlarmIdentifier alarmIdentifier() {
        return alarmIdentifier;
    }

    /**
     * <p>
     * When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want
     * Amazon Route 53 to assign to the health check:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Healthy</code>: Route 53 considers the health check to be healthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that CloudWatch had
     * sufficient data to determine the alarm state. For new health checks that have no last known status, the default
     * status for the health check is healthy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #insufficientDataHealthStatus} will return {@link InsufficientDataHealthStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #insufficientDataHealthStatusAsString}.
     * </p>
     * 
     * @return When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you
     *         want Amazon Route 53 to assign to the health check:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Healthy</code>: Route 53 considers the health check to be healthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that
     *         CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last
     *         known status, the default status for the health check is healthy.
     *         </p>
     *         </li>
     * @see InsufficientDataHealthStatus
     */
    public final InsufficientDataHealthStatus insufficientDataHealthStatus() {
        return InsufficientDataHealthStatus.fromValue(insufficientDataHealthStatus);
    }

    /**
     * <p>
     * When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want
     * Amazon Route 53 to assign to the health check:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Healthy</code>: Route 53 considers the health check to be healthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that CloudWatch had
     * sufficient data to determine the alarm state. For new health checks that have no last known status, the default
     * status for the health check is healthy.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #insufficientDataHealthStatus} will return {@link InsufficientDataHealthStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #insufficientDataHealthStatusAsString}.
     * </p>
     * 
     * @return When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you
     *         want Amazon Route 53 to assign to the health check:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Healthy</code>: Route 53 considers the health check to be healthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that
     *         CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last
     *         known status, the default status for the health check is healthy.
     *         </p>
     *         </li>
     * @see InsufficientDataHealthStatus
     */
    public final String insufficientDataHealthStatusAsString() {
        return insufficientDataHealthStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for Route53 Application Recovery Controller routing control.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for Route53 Application Recovery Controller routing control.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(searchString());
        hashCode = 31 * hashCode + Objects.hashCode(requestInterval());
        hashCode = 31 * hashCode + Objects.hashCode(failureThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(measureLatency());
        hashCode = 31 * hashCode + Objects.hashCode(inverted());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(healthThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(hasChildHealthChecks() ? childHealthChecks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableSNI());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(alarmIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(insufficientDataHealthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(port(), other.port())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(resourcePath(), other.resourcePath())
                && Objects.equals(fullyQualifiedDomainName(), other.fullyQualifiedDomainName())
                && Objects.equals(searchString(), other.searchString())
                && Objects.equals(requestInterval(), other.requestInterval())
                && Objects.equals(failureThreshold(), other.failureThreshold())
                && Objects.equals(measureLatency(), other.measureLatency()) && Objects.equals(inverted(), other.inverted())
                && Objects.equals(disabled(), other.disabled()) && Objects.equals(healthThreshold(), other.healthThreshold())
                && hasChildHealthChecks() == other.hasChildHealthChecks()
                && Objects.equals(childHealthChecks(), other.childHealthChecks())
                && Objects.equals(enableSNI(), other.enableSNI()) && hasRegions() == other.hasRegions()
                && Objects.equals(regionsAsStrings(), other.regionsAsStrings())
                && Objects.equals(alarmIdentifier(), other.alarmIdentifier())
                && Objects.equals(insufficientDataHealthStatusAsString(), other.insufficientDataHealthStatusAsString())
                && Objects.equals(routingControlArn(), other.routingControlArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthCheckConfig").add("IPAddress", ipAddress()).add("Port", port())
                .add("Type", typeAsString()).add("ResourcePath", resourcePath())
                .add("FullyQualifiedDomainName", fullyQualifiedDomainName()).add("SearchString", searchString())
                .add("RequestInterval", requestInterval()).add("FailureThreshold", failureThreshold())
                .add("MeasureLatency", measureLatency()).add("Inverted", inverted()).add("Disabled", disabled())
                .add("HealthThreshold", healthThreshold())
                .add("ChildHealthChecks", hasChildHealthChecks() ? childHealthChecks() : null).add("EnableSNI", enableSNI())
                .add("Regions", hasRegions() ? regionsAsStrings() : null).add("AlarmIdentifier", alarmIdentifier())
                .add("InsufficientDataHealthStatus", insufficientDataHealthStatusAsString())
                .add("RoutingControlArn", routingControlArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IPAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ResourcePath":
            return Optional.ofNullable(clazz.cast(resourcePath()));
        case "FullyQualifiedDomainName":
            return Optional.ofNullable(clazz.cast(fullyQualifiedDomainName()));
        case "SearchString":
            return Optional.ofNullable(clazz.cast(searchString()));
        case "RequestInterval":
            return Optional.ofNullable(clazz.cast(requestInterval()));
        case "FailureThreshold":
            return Optional.ofNullable(clazz.cast(failureThreshold()));
        case "MeasureLatency":
            return Optional.ofNullable(clazz.cast(measureLatency()));
        case "Inverted":
            return Optional.ofNullable(clazz.cast(inverted()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "HealthThreshold":
            return Optional.ofNullable(clazz.cast(healthThreshold()));
        case "ChildHealthChecks":
            return Optional.ofNullable(clazz.cast(childHealthChecks()));
        case "EnableSNI":
            return Optional.ofNullable(clazz.cast(enableSNI()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regionsAsStrings()));
        case "AlarmIdentifier":
            return Optional.ofNullable(clazz.cast(alarmIdentifier()));
        case "InsufficientDataHealthStatus":
            return Optional.ofNullable(clazz.cast(insufficientDataHealthStatusAsString()));
        case "RoutingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckConfig, T> g) {
        return obj -> g.apply((HealthCheckConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckConfig> {
        /**
         * <p>
         * The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on. If you
         * don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name
         * that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify in
         * <code>RequestInterval</code>. Using an IP address returned by DNS, Route 53 then checks the health of the
         * endpoint.
         * </p>
         * <p>
         * Use one of the following formats for the value of <code>IPAddress</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example,
         * <code>192.0.2.44</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example,
         * <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC
         * 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with
         * your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP
         * address of your instance will never change.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName"
         * >FullyQualifiedDomainName</a>.
         * </p>
         * <p>
         * Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private,
         * non-routable, or multicast ranges. For more information about IP addresses for which you can't create health
         * checks, see the following documents:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address
         * Space</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * When the value of <code>Type</code> is <code>CALCULATED</code> or <code>CLOUDWATCH_METRIC</code>, omit
         * <code>IPAddress</code>.
         * </p>
         * 
         * @param ipAddress
         *        The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to perform health checks on.
         *        If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to resolve the
         *        domain name that you specify in <code>FullyQualifiedDomainName</code> at the interval that you specify
         *        in <code>RequestInterval</code>. Using an IP address returned by DNS, Route 53 then checks the health
         *        of the endpoint.</p>
         *        <p>
         *        Use one of the following formats for the value of <code>IPAddress</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.), for example,
         *        <code>192.0.2.44</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:), for example,
         *        <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described
         *        in RFC 5952, for example, <code>2001:db8:85a3::abcd:1:2345</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it
         *        with your EC2 instance, and specify the Elastic IP address for <code>IPAddress</code>. This ensures
         *        that the IP address of your instance will never change.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName"
         *        >FullyQualifiedDomainName</a>.
         *        </p>
         *        <p>
         *        Constraints: Route 53 can't check the health of endpoints for which the IP address is in local,
         *        private, non-routable, or multicast ranges. For more information about IP addresses for which you
         *        can't create health checks, see the following documents:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address
         *        Space</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When the value of <code>Type</code> is <code>CALCULATED</code> or <code>CLOUDWATCH_METRIC</code>, omit
         *        <code>IPAddress</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The port on the endpoint that you want Amazon Route 53 to perform health checks on.
         * </p>
         * <note>
         * <p>
         * Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of
         * <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.
         * </p>
         * </note>
         * 
         * @param port
         *        The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p> <note>
         *        <p>
         *        Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of
         *        <code>CLOUDWATCH_METRIC</code> or <code>CALCULATED</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
         * endpoint is healthy.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * </p>
         * </important>
         * <p>
         * You can create the following types of health checks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * <important>
         * <p>
         * If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS v1.0 or
         * later.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
         * request and searches the first 5,120 bytes of the response body for the string that you specify in
         * <code>SearchString</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
         * <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that you
         * specify in <code>SearchString</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TCP</b>: Route 53 tries to establish a TCP connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the alarm
         * is <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>, the health
         * check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is
         * <code>OK</code> or <code>ALARM</code>, the health check status depends on the setting for
         * <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>, or
         * <code>LastKnownStatus</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up the
         * number of health checks that Route 53 health checkers consider to be healthy and compares that number with
         * the value of <code>HealthThreshold</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller routing
         * control. If the routing control state is <code>ON</code>, the health check is considered healthy. If the
         * state is <code>OFF</code>, the health check is considered unhealthy.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of health check that you want to create, which indicates how Amazon Route 53 determines
         *        whether an endpoint is healthy.</p> <important>
         *        <p>
         *        You can't change the value of <code>Type</code> after you create a health check.
         *        </p>
         *        </important>
         *        <p>
         *        You can create the following types of health checks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS
         *        v1.0 or later.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
         *        an HTTP request and searches the first 5,120 bytes of the response body for the string that you
         *        specify in <code>SearchString</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
         *        an <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string
         *        that you specify in <code>SearchString</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TCP</b>: Route 53 tries to establish a TCP connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the
         *        alarm is <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>,
         *        the health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine
         *        whether the state is <code>OK</code> or <code>ALARM</code>, the health check status depends on the
         *        setting for <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>,
         *        or <code>LastKnownStatus</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up
         *        the number of health checks that Route 53 health checkers consider to be healthy and compares that
         *        number with the value of <code>HealthThreshold</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller
         *        routing control. If the routing control state is <code>ON</code>, the health check is considered
         *        healthy. If the state is <code>OFF</code>, the health check is considered unhealthy.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         *        Guide</i>.
         * @see HealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of health check that you want to create, which indicates how Amazon Route 53 determines whether an
         * endpoint is healthy.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>Type</code> after you create a health check.
         * </p>
         * </important>
         * <p>
         * You can create the following types of health checks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS request
         * and waits for an HTTP status code of 200 or greater and less than 400.
         * </p>
         * <important>
         * <p>
         * If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS v1.0 or
         * later.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
         * request and searches the first 5,120 bytes of the response body for the string that you specify in
         * <code>SearchString</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an
         * <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string that you
         * specify in <code>SearchString</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TCP</b>: Route 53 tries to establish a TCP connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the alarm
         * is <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>, the health
         * check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine whether the state is
         * <code>OK</code> or <code>ALARM</code>, the health check status depends on the setting for
         * <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>, or
         * <code>LastKnownStatus</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up the
         * number of health checks that Route 53 health checkers consider to be healthy and compares that number with
         * the value of <code>HealthThreshold</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller routing
         * control. If the routing control state is <code>ON</code>, the health check is considered healthy. If the
         * state is <code>OFF</code>, the health check is considered unhealthy.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of health check that you want to create, which indicates how Amazon Route 53 determines
         *        whether an endpoint is healthy.</p> <important>
         *        <p>
         *        You can't change the value of <code>Type</code> after you create a health check.
         *        </p>
         *        </important>
         *        <p>
         *        You can create the following types of health checks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>HTTP</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTP
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits an HTTPS
         *        request and waits for an HTTP status code of 200 or greater and less than 400.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify <code>HTTPS</code> for the value of <code>Type</code>, the endpoint must support TLS
         *        v1.0 or later.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>HTTP_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
         *        an HTTP request and searches the first 5,120 bytes of the response body for the string that you
         *        specify in <code>SearchString</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>HTTPS_STR_MATCH</b>: Route 53 tries to establish a TCP connection. If successful, Route 53 submits
         *        an <code>HTTPS</code> request and searches the first 5,120 bytes of the response body for the string
         *        that you specify in <code>SearchString</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TCP</b>: Route 53 tries to establish a TCP connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CLOUDWATCH_METRIC</b>: The health check is associated with a CloudWatch alarm. If the state of the
         *        alarm is <code>OK</code>, the health check is considered healthy. If the state is <code>ALARM</code>,
         *        the health check is considered unhealthy. If CloudWatch doesn't have sufficient data to determine
         *        whether the state is <code>OK</code> or <code>ALARM</code>, the health check status depends on the
         *        setting for <code>InsufficientDataHealthStatus</code>: <code>Healthy</code>, <code>Unhealthy</code>,
         *        or <code>LastKnownStatus</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CALCULATED</b>: For health checks that monitor the status of other health checks, Route 53 adds up
         *        the number of health checks that Route 53 health checkers consider to be healthy and compares that
         *        number with the value of <code>HealthThreshold</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>RECOVERY_CONTROL</b>: The health check is assocated with a Route53 Application Recovery Controller
         *        routing control. If the routing control state is <code>ON</code>, the health check is considered
         *        healthy. If the state is <code>OFF</code>, the health check is considered unhealthy.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         *        Guide</i>.
         * @see HealthCheckType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckType
         */
        Builder type(HealthCheckType type);

        /**
         * <p>
         * The path, if any, that you want Amazon Route 53 to request when performing health checks. The path can be any
         * value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for
         * example, the file /docs/route53-health-check.html. You can also include query string parameters, for example,
         * <code>/welcome.html?language=jp&amp;login=y</code>.
         * </p>
         * 
         * @param resourcePath
         *        The path, if any, that you want Amazon Route 53 to request when performing health checks. The path can
         *        be any value for which your endpoint will return an HTTP status code of 2xx or 3xx when the endpoint
         *        is healthy, for example, the file /docs/route53-health-check.html. You can also include query string
         *        parameters, for example, <code>/welcome.html?language=jp&amp;login=y</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePath(String resourcePath);

        /**
         * <p>
         * Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.
         * </p>
         * <p>
         * <b>If you specify a value for</b> <code>IPAddress</code>:
         * </p>
         * <p>
         * Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of
         * <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except TCP health
         * checks. This is typically the fully qualified DNS name of the endpoint on which you want Route 53 to perform
         * health checks.
         * </p>
         * <p>
         * When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or
         * <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
         * <code>FullyQualifiedDomainName</code> to the endpoint in the Host header.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or
         * <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
         * <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify another value for <code>Port</code> and any value except <code>TCP</code> for
         * <code>Type</code>, Route 53 passes <code>FullyQualifiedDomainName:Port</code> to the endpoint in the
         * <code>Host</code> header.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of
         * <code>IPAddress</code> in the <code>Host</code> header in each of the preceding cases.
         * </p>
         * <p>
         * <b>If you don't specify a value for <code>IPAddress</code> </b>:
         * </p>
         * <p>
         * Route 53 sends a DNS request to the domain that you specify for <code>FullyQualifiedDomainName</code> at the
         * interval that you specify for <code>RequestInterval</code>. Using an IPv4 address that DNS returns, Route 53
         * then checks the health of the endpoint.
         * </p>
         * <note>
         * <p>
         * If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the
         * endpoint. If there's no resource record set with a type of A for the name that you specify for
         * <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.
         * </p>
         * </note>
         * <p>
         * If you want to check the health of weighted, latency, or failover resource record sets and you choose to
         * specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a separate
         * health check for each endpoint. For example, create a health check for each HTTP server that is serving
         * content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>, specify the domain name
         * of the server (such as us-east-2-www.example.com), not the name of the resource record sets
         * (www.example.com).
         * </p>
         * <important>
         * <p>
         * In this configuration, if you create a health check for which the value of
         * <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then associate the
         * health check with those resource record sets, health check results will be unpredictable.
         * </p>
         * </important>
         * <p>
         * In addition, if the value that you specify for <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>,
         * <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of
         * <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you specify a value
         * for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a
         * <code>Host</code> header.
         * </p>
         * 
         * @param fullyQualifiedDomainName
         *        Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p>
         *        <p>
         *        <b>If you specify a value for</b> <code>IPAddress</code>:
         *        </p>
         *        <p>
         *        Amazon Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value
         *        of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header for all health checks except
         *        TCP health checks. This is typically the fully qualified DNS name of the endpoint on which you want
         *        Route 53 to perform health checks.
         *        </p>
         *        <p>
         *        When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code>
         *        header:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or
         *        <code>HTTP_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
         *        <code>FullyQualifiedDomainName</code> to the endpoint in the Host header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or
         *        <code>HTTPS_STR_MATCH</code> for <code>Type</code>, Route 53 passes the value of
         *        <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify another value for <code>Port</code> and any value except <code>TCP</code> for
         *        <code>Type</code>, Route 53 passes <code>FullyQualifiedDomainName:Port</code> to the endpoint in the
         *        <code>Host</code> header.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value
         *        of <code>IPAddress</code> in the <code>Host</code> header in each of the preceding cases.
         *        </p>
         *        <p>
         *        <b>If you don't specify a value for <code>IPAddress</code> </b>:
         *        </p>
         *        <p>
         *        Route 53 sends a DNS request to the domain that you specify for <code>FullyQualifiedDomainName</code>
         *        at the interval that you specify for <code>RequestInterval</code>. Using an IPv4 address that DNS
         *        returns, Route 53 then checks the health of the endpoint.
         *        </p>
         *        <note>
         *        <p>
         *        If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks
         *        to the endpoint. If there's no resource record set with a type of A for the name that you specify for
         *        <code>FullyQualifiedDomainName</code>, the health check fails with a "DNS resolution failed" error.
         *        </p>
         *        </note>
         *        <p>
         *        If you want to check the health of weighted, latency, or failover resource record sets and you choose
         *        to specify the endpoint only by <code>FullyQualifiedDomainName</code>, we recommend that you create a
         *        separate health check for each endpoint. For example, create a health check for each HTTP server that
         *        is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>,
         *        specify the domain name of the server (such as us-east-2-www.example.com), not the name of the
         *        resource record sets (www.example.com).
         *        </p>
         *        <important>
         *        <p>
         *        In this configuration, if you create a health check for which the value of
         *        <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and you then
         *        associate the health check with those resource record sets, health check results will be
         *        unpredictable.
         *        </p>
         *        </important>
         *        <p>
         *        In addition, if the value that you specify for <code>Type</code> is <code>HTTP</code>,
         *        <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or <code>HTTPS_STR_MATCH</code>, Route 53 passes the
         *        value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does when you
         *        specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>,
         *        Route 53 doesn't pass a <code>Host</code> header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedDomainName(String fullyQualifiedDomainName);

        /**
         * <p>
         * If the value of Type is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want
         * Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the
         * response body, Route 53 considers the resource healthy.
         * </p>
         * <p>
         * Route 53 considers case when searching for <code>SearchString</code> in the response body.
         * </p>
         * 
         * @param searchString
         *        If the value of Type is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that
         *        you want Amazon Route 53 to search for in the response body from the specified resource. If the string
         *        appears in the response body, Route 53 considers the resource healthy.</p>
         *        <p>
         *        Route 53 considers case when searching for <code>SearchString</code> in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchString(String searchString);

        /**
         * <p>
         * The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time
         * that it sends the next health check request. Each Route 53 health checker makes requests at this interval.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>RequestInterval</code> after you create a health check.
         * </p>
         * </important>
         * <p>
         * If you don't specify a value for <code>RequestInterval</code>, the default value is <code>30</code> seconds.
         * </p>
         * 
         * @param requestInterval
         *        The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the
         *        time that it sends the next health check request. Each Route 53 health checker makes requests at this
         *        interval.</p> <important>
         *        <p>
         *        You can't change the value of <code>RequestInterval</code> after you create a health check.
         *        </p>
         *        </important>
         *        <p>
         *        If you don't specify a value for <code>RequestInterval</code>, the default value is <code>30</code>
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestInterval(Integer requestInterval);

        /**
         * <p>
         * The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the
         * current status of the endpoint from unhealthy to healthy or vice versa. For more information, see <a href=
         * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         * >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         * Guide</i>.
         * </p>
         * <p>
         * If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.
         * </p>
         * 
         * @param failureThreshold
         *        The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to
         *        change the current status of the endpoint from unhealthy to healthy or vice versa. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html"
         *        >How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a> in the <i>Amazon Route 53 Developer
         *        Guide</i>.</p>
         *        <p>
         *        If you don't specify a value for <code>FailureThreshold</code>, the default value is three health
         *        checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureThreshold(Integer failureThreshold);

        /**
         * <p>
         * Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple Amazon
         * Web Services regions and your endpoint, and to display CloudWatch latency graphs on the <b>Health Checks</b>
         * page in the Route 53 console.
         * </p>
         * <important>
         * <p>
         * You can't change the value of <code>MeasureLatency</code> after you create a health check.
         * </p>
         * </important>
         * 
         * @param measureLatency
         *        Specify whether you want Amazon Route 53 to measure the latency between health checkers in multiple
         *        Amazon Web Services regions and your endpoint, and to display CloudWatch latency graphs on the
         *        <b>Health Checks</b> page in the Route 53 console.</p> <important>
         *        <p>
         *        You can't change the value of <code>MeasureLatency</code> after you create a health check.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureLatency(Boolean measureLatency);

        /**
         * <p>
         * Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a
         * health check unhealthy when it otherwise would be considered healthy.
         * </p>
         * 
         * @param inverted
         *        Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to
         *        consider a health check unhealthy when it otherwise would be considered healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inverted(Boolean inverted);

        /**
         * <p>
         * Stops Route 53 from performing health checks. When you disable a health check, here's what happens:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your
         * application, server, or other resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health checks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding CloudWatch
         * metrics.
         * </p>
         * </li>
         * </ul>
         * <p>
         * After you disable a health check, Route 53 considers the status of the health check to always be healthy. If
         * you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want
         * to stop routing traffic to a resource, change the value of <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted"
         * >Inverted</a>.
         * </p>
         * <p>
         * Charges for a health check still apply when the health check is disabled. For more information, see <a
         * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
         * </p>
         * 
         * @param disabled
         *        Stops Route 53 from performing health checks. When you disable a health check, here's what
         *        happens:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Health checks that check the health of endpoints:</b> Route 53 stops submitting requests to your
         *        application, server, or other resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Calculated health checks:</b> Route 53 stops aggregating the status of the referenced health
         *        checks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Health checks that monitor CloudWatch alarms:</b> Route 53 stops monitoring the corresponding
         *        CloudWatch metrics.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After you disable a health check, Route 53 considers the status of the health check to always be
         *        healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding
         *        resources. If you want to stop routing traffic to a resource, change the value of <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted"
         *        >Inverted</a>.
         *        </p>
         *        <p>
         *        Charges for a health check still apply when the health check is disabled. For more information, see <a
         *        href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * The number of child health checks that are associated with a <code>CALCULATED</code> health check that Amazon
         * Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered healthy. To
         * specify the child health checks that you want to associate with a <code>CALCULATED</code> health check, use
         * the <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks"
         * >ChildHealthChecks</a> element.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify a number greater than the number of child health checks, Route 53 always considers this health
         * check to be unhealthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>0</code>, Route 53 always considers this health check to be healthy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param healthThreshold
         *        The number of child health checks that are associated with a <code>CALCULATED</code> health check that
         *        Amazon Route 53 must consider healthy for the <code>CALCULATED</code> health check to be considered
         *        healthy. To specify the child health checks that you want to associate with a <code>CALCULATED</code>
         *        health check, use the <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks"
         *        >ChildHealthChecks</a> element.</p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify a number greater than the number of child health checks, Route 53 always considers this
         *        health check to be unhealthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>0</code>, Route 53 always considers this health check to be healthy.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthThreshold(Integer healthThreshold);

        /**
         * <p>
         * (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element for
         * each health check that you want to associate with a <code>CALCULATED</code> health check.
         * </p>
         * 
         * @param childHealthChecks
         *        (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element
         *        for each health check that you want to associate with a <code>CALCULATED</code> health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childHealthChecks(Collection<String> childHealthChecks);

        /**
         * <p>
         * (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element for
         * each health check that you want to associate with a <code>CALCULATED</code> health check.
         * </p>
         * 
         * @param childHealthChecks
         *        (CALCULATED Health Checks Only) A complex type that contains one <code>ChildHealthCheck</code> element
         *        for each health check that you want to associate with a <code>CALCULATED</code> health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childHealthChecks(String... childHealthChecks);

        /**
         * <p>
         * Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the
         * endpoint in the <code>client_hello</code> message during TLS negotiation. This allows the endpoint to respond
         * to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.
         * </p>
         * <p>
         * Some endpoints require that <code>HTTPS</code> requests include the host name in the
         * <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be
         * <code>SSL alert handshake_failure</code>. A health check can also have that status for other reasons. If SNI
         * is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm
         * that your certificate is valid.
         * </p>
         * <p>
         * The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and
         * possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names in the
         * certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>. If the
         * endpoint responds to the <code>client_hello</code> message with a certificate that does not include the
         * domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the
         * handshake. In the second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the
         * <code>client_hello</code> message.
         * </p>
         * 
         * @param enableSNI
         *        Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to
         *        the endpoint in the <code>client_hello</code> message during TLS negotiation. This allows the endpoint
         *        to respond to <code>HTTPS</code> health check requests with the applicable SSL/TLS certificate.</p>
         *        <p>
         *        Some endpoints require that <code>HTTPS</code> requests include the host name in the
         *        <code>client_hello</code> message. If you don't enable SNI, the status of the health check will be
         *        <code>SSL alert handshake_failure</code>. A health check can also have that status for other reasons.
         *        If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint
         *        and confirm that your certificate is valid.
         *        </p>
         *        <p>
         *        The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field
         *        and possibly several more in the <code>Subject Alternative Names</code> field. One of the domain names
         *        in the certificate should match the value that you specify for <code>FullyQualifiedDomainName</code>.
         *        If the endpoint responds to the <code>client_hello</code> message with a certificate that does not
         *        include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker
         *        will retry the handshake. In the second attempt, the health checker will omit
         *        <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSNI(Boolean enableSNI);

        /**
         * <p>
         * A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route
         * 53 health checkers to check the specified endpoint.
         * </p>
         * <p>
         * If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the
         * regions that are listed under <b>Valid Values</b>.
         * </p>
         * <p>
         * If you update a health check to remove a region that has been performing health checks, Route 53 will briefly
         * continue to perform checks from that region to ensure that some health checkers are always checking the
         * endpoint (for example, if you replace three regions with four different regions).
         * </p>
         * 
         * @param regions
         *        A complex type that contains one <code>Region</code> element for each region from which you want
         *        Amazon Route 53 health checkers to check the specified endpoint.</p>
         *        <p>
         *        If you don't specify any regions, Route 53 health checkers automatically performs checks from all of
         *        the regions that are listed under <b>Valid Values</b>.
         *        </p>
         *        <p>
         *        If you update a health check to remove a region that has been performing health checks, Route 53 will
         *        briefly continue to perform checks from that region to ensure that some health checkers are always
         *        checking the endpoint (for example, if you replace three regions with four different regions).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsWithStrings(Collection<String> regions);

        /**
         * <p>
         * A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route
         * 53 health checkers to check the specified endpoint.
         * </p>
         * <p>
         * If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the
         * regions that are listed under <b>Valid Values</b>.
         * </p>
         * <p>
         * If you update a health check to remove a region that has been performing health checks, Route 53 will briefly
         * continue to perform checks from that region to ensure that some health checkers are always checking the
         * endpoint (for example, if you replace three regions with four different regions).
         * </p>
         * 
         * @param regions
         *        A complex type that contains one <code>Region</code> element for each region from which you want
         *        Amazon Route 53 health checkers to check the specified endpoint.</p>
         *        <p>
         *        If you don't specify any regions, Route 53 health checkers automatically performs checks from all of
         *        the regions that are listed under <b>Valid Values</b>.
         *        </p>
         *        <p>
         *        If you update a health check to remove a region that has been performing health checks, Route 53 will
         *        briefly continue to perform checks from that region to ensure that some health checkers are always
         *        checking the endpoint (for example, if you replace three regions with four different regions).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsWithStrings(String... regions);

        /**
         * <p>
         * A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route
         * 53 health checkers to check the specified endpoint.
         * </p>
         * <p>
         * If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the
         * regions that are listed under <b>Valid Values</b>.
         * </p>
         * <p>
         * If you update a health check to remove a region that has been performing health checks, Route 53 will briefly
         * continue to perform checks from that region to ensure that some health checkers are always checking the
         * endpoint (for example, if you replace three regions with four different regions).
         * </p>
         * 
         * @param regions
         *        A complex type that contains one <code>Region</code> element for each region from which you want
         *        Amazon Route 53 health checkers to check the specified endpoint.</p>
         *        <p>
         *        If you don't specify any regions, Route 53 health checkers automatically performs checks from all of
         *        the regions that are listed under <b>Valid Values</b>.
         *        </p>
         *        <p>
         *        If you update a health check to remove a region that has been performing health checks, Route 53 will
         *        briefly continue to perform checks from that region to ensure that some health checkers are always
         *        checking the endpoint (for example, if you replace three regions with four different regions).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<HealthCheckRegion> regions);

        /**
         * <p>
         * A complex type that contains one <code>Region</code> element for each region from which you want Amazon Route
         * 53 health checkers to check the specified endpoint.
         * </p>
         * <p>
         * If you don't specify any regions, Route 53 health checkers automatically performs checks from all of the
         * regions that are listed under <b>Valid Values</b>.
         * </p>
         * <p>
         * If you update a health check to remove a region that has been performing health checks, Route 53 will briefly
         * continue to perform checks from that region to ensure that some health checkers are always checking the
         * endpoint (for example, if you replace three regions with four different regions).
         * </p>
         * 
         * @param regions
         *        A complex type that contains one <code>Region</code> element for each region from which you want
         *        Amazon Route 53 health checkers to check the specified endpoint.</p>
         *        <p>
         *        If you don't specify any regions, Route 53 health checkers automatically performs checks from all of
         *        the regions that are listed under <b>Valid Values</b>.
         *        </p>
         *        <p>
         *        If you update a health check to remove a region that has been performing health checks, Route 53 will
         *        briefly continue to perform checks from that region to ensure that some health checkers are always
         *        checking the endpoint (for example, if you replace three regions with four different regions).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(HealthCheckRegion... regions);

        /**
         * <p>
         * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to
         * determine whether the specified health check is healthy.
         * </p>
         * 
         * @param alarmIdentifier
         *        A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to
         *        use to determine whether the specified health check is healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmIdentifier(AlarmIdentifier alarmIdentifier);

        /**
         * <p>
         * A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to
         * determine whether the specified health check is healthy.
         * </p>
         * This is a convenience that creates an instance of the {@link AlarmIdentifier.Builder} avoiding the need to
         * create one manually via {@link AlarmIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlarmIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmIdentifier(AlarmIdentifier)}.
         * 
         * @param alarmIdentifier
         *        a consumer that will call methods on {@link AlarmIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmIdentifier(AlarmIdentifier)
         */
        default Builder alarmIdentifier(Consumer<AlarmIdentifier.Builder> alarmIdentifier) {
            return alarmIdentifier(AlarmIdentifier.builder().applyMutation(alarmIdentifier).build());
        }

        /**
         * <p>
         * When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want
         * Amazon Route 53 to assign to the health check:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Healthy</code>: Route 53 considers the health check to be healthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that CloudWatch
         * had sufficient data to determine the alarm state. For new health checks that have no last known status, the
         * default status for the health check is healthy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param insufficientDataHealthStatus
         *        When CloudWatch has insufficient data about the metric to determine the alarm state, the status that
         *        you want Amazon Route 53 to assign to the health check:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Healthy</code>: Route 53 considers the health check to be healthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that
         *        CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last
         *        known status, the default status for the health check is healthy.
         *        </p>
         *        </li>
         * @see InsufficientDataHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsufficientDataHealthStatus
         */
        Builder insufficientDataHealthStatus(String insufficientDataHealthStatus);

        /**
         * <p>
         * When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want
         * Amazon Route 53 to assign to the health check:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Healthy</code>: Route 53 considers the health check to be healthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that CloudWatch
         * had sufficient data to determine the alarm state. For new health checks that have no last known status, the
         * default status for the health check is healthy.
         * </p>
         * </li>
         * </ul>
         * 
         * @param insufficientDataHealthStatus
         *        When CloudWatch has insufficient data about the metric to determine the alarm state, the status that
         *        you want Amazon Route 53 to assign to the health check:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Healthy</code>: Route 53 considers the health check to be healthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time that
         *        CloudWatch had sufficient data to determine the alarm state. For new health checks that have no last
         *        known status, the default status for the health check is healthy.
         *        </p>
         *        </li>
         * @see InsufficientDataHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsufficientDataHealthStatus
         */
        Builder insufficientDataHealthStatus(InsufficientDataHealthStatus insufficientDataHealthStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for Route53 Application Recovery Controller routing control.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) for Route53 Application Recovery Controller routing control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private Integer port;

        private String type;

        private String resourcePath;

        private String fullyQualifiedDomainName;

        private String searchString;

        private Integer requestInterval;

        private Integer failureThreshold;

        private Boolean measureLatency;

        private Boolean inverted;

        private Boolean disabled;

        private Integer healthThreshold;

        private List<String> childHealthChecks = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableSNI;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private AlarmIdentifier alarmIdentifier;

        private String insufficientDataHealthStatus;

        private String routingControlArn;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfig model) {
            ipAddress(model.ipAddress);
            port(model.port);
            type(model.type);
            resourcePath(model.resourcePath);
            fullyQualifiedDomainName(model.fullyQualifiedDomainName);
            searchString(model.searchString);
            requestInterval(model.requestInterval);
            failureThreshold(model.failureThreshold);
            measureLatency(model.measureLatency);
            inverted(model.inverted);
            disabled(model.disabled);
            healthThreshold(model.healthThreshold);
            childHealthChecks(model.childHealthChecks);
            enableSNI(model.enableSNI);
            regionsWithStrings(model.regions);
            alarmIdentifier(model.alarmIdentifier);
            insufficientDataHealthStatus(model.insufficientDataHealthStatus);
            routingControlArn(model.routingControlArn);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        @Transient
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(HealthCheckType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResourcePath() {
            return resourcePath;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        @Override
        @Transient
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public final String getFullyQualifiedDomainName() {
            return fullyQualifiedDomainName;
        }

        public final void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
        }

        @Override
        @Transient
        public final Builder fullyQualifiedDomainName(String fullyQualifiedDomainName) {
            this.fullyQualifiedDomainName = fullyQualifiedDomainName;
            return this;
        }

        public final String getSearchString() {
            return searchString;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        @Override
        @Transient
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final Integer getRequestInterval() {
            return requestInterval;
        }

        public final void setRequestInterval(Integer requestInterval) {
            this.requestInterval = requestInterval;
        }

        @Override
        @Transient
        public final Builder requestInterval(Integer requestInterval) {
            this.requestInterval = requestInterval;
            return this;
        }

        public final Integer getFailureThreshold() {
            return failureThreshold;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        @Transient
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final Boolean getMeasureLatency() {
            return measureLatency;
        }

        public final void setMeasureLatency(Boolean measureLatency) {
            this.measureLatency = measureLatency;
        }

        @Override
        @Transient
        public final Builder measureLatency(Boolean measureLatency) {
            this.measureLatency = measureLatency;
            return this;
        }

        public final Boolean getInverted() {
            return inverted;
        }

        public final void setInverted(Boolean inverted) {
            this.inverted = inverted;
        }

        @Override
        @Transient
        public final Builder inverted(Boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        @Transient
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final Integer getHealthThreshold() {
            return healthThreshold;
        }

        public final void setHealthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
        }

        @Override
        @Transient
        public final Builder healthThreshold(Integer healthThreshold) {
            this.healthThreshold = healthThreshold;
            return this;
        }

        public final Collection<String> getChildHealthChecks() {
            if (childHealthChecks instanceof SdkAutoConstructList) {
                return null;
            }
            return childHealthChecks;
        }

        public final void setChildHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
        }

        @Override
        @Transient
        public final Builder childHealthChecks(Collection<String> childHealthChecks) {
            this.childHealthChecks = ChildHealthCheckListCopier.copy(childHealthChecks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder childHealthChecks(String... childHealthChecks) {
            childHealthChecks(Arrays.asList(childHealthChecks));
            return this;
        }

        public final Boolean getEnableSNI() {
            return enableSNI;
        }

        public final void setEnableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
        }

        @Override
        @Transient
        public final Builder enableSNI(Boolean enableSNI) {
            this.enableSNI = enableSNI;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
        }

        @Override
        @Transient
        public final Builder regionsWithStrings(Collection<String> regions) {
            this.regions = HealthCheckRegionListCopier.copy(regions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regionsWithStrings(String... regions) {
            regionsWithStrings(Arrays.asList(regions));
            return this;
        }

        @Override
        @Transient
        public final Builder regions(Collection<HealthCheckRegion> regions) {
            this.regions = HealthCheckRegionListCopier.copyEnumToString(regions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regions(HealthCheckRegion... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final AlarmIdentifier.Builder getAlarmIdentifier() {
            return alarmIdentifier != null ? alarmIdentifier.toBuilder() : null;
        }

        public final void setAlarmIdentifier(AlarmIdentifier.BuilderImpl alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier != null ? alarmIdentifier.build() : null;
        }

        @Override
        @Transient
        public final Builder alarmIdentifier(AlarmIdentifier alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
            return this;
        }

        public final String getInsufficientDataHealthStatus() {
            return insufficientDataHealthStatus;
        }

        public final void setInsufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
        }

        @Override
        @Transient
        public final Builder insufficientDataHealthStatus(String insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus = insufficientDataHealthStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder insufficientDataHealthStatus(InsufficientDataHealthStatus insufficientDataHealthStatus) {
            this.insufficientDataHealthStatus(insufficientDataHealthStatus == null ? null : insufficientDataHealthStatus
                    .toString());
            return this;
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        @Transient
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        @Override
        public HealthCheckConfig build() {
            return new HealthCheckConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
