/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieves a list of the public and private hosted zones that are associated with the current account in ASCII order
 * by domain name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHostedZonesByNameRequest extends Route53Request implements
        ToCopyableBuilder<ListHostedZonesByNameRequest.Builder, ListHostedZonesByNameRequest> {
    private static final SdkField<String> DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DNSName")
            .getter(getter(ListHostedZonesByNameRequest::dnsName))
            .setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dnsname")
                    .unmarshallLocationName("dnsname").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId")
            .getter(getter(ListHostedZonesByNameRequest::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hostedzoneid")
                    .unmarshallLocationName("hostedzoneid").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListHostedZonesByNameRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems")
                    .unmarshallLocationName("maxitems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_NAME_FIELD,
            HOSTED_ZONE_ID_FIELD, MAX_ITEMS_FIELD));

    private final String dnsName;

    private final String hostedZoneId;

    private final String maxItems;

    private ListHostedZonesByNameRequest(BuilderImpl builder) {
        super(builder);
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * (Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code>
     * parameter only if you want to specify the name of the first hosted zone in the response. If you don't include the
     * <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the current
     * account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and <code>hostedzoneid</code>
     * parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.
     * </p>
     * 
     * @return (Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code>
     *         parameter only if you want to specify the name of the first hosted zone in the response. If you don't
     *         include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were
     *         created by the current account, in ASCII order. For subsequent requests, include both
     *         <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the
     *         value of <code>NextDNSName</code> from the previous response.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
     * <code>hostedzoneid</code> parameter.
     * </p>
     * <p>
     * If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns
     * only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones,
     * submit another request to <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>, specify the value of the
     * <code>NextHostedZoneId</code> element from the previous response.
     * </p>
     * 
     * @return (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
     *         <code>hostedzoneid</code> parameter.</p>
     *         <p>
     *         If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code>
     *         returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code>
     *         hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both
     *         <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>
     *         , specify the value of the <code>NextHostedZoneId</code> element from the previous response.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The maximum number of hosted zones to be included in the response body for this request. If you have more than
     * <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the response is
     * true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the first hosted zone
     * in the next group of <code>maxitems</code> hosted zones.
     * </p>
     * 
     * @return The maximum number of hosted zones to be included in the response body for this request. If you have more
     *         than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the
     *         response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify
     *         the first hosted zone in the next group of <code>maxitems</code> hosted zones.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameRequest)) {
            return false;
        }
        ListHostedZonesByNameRequest other = (ListHostedZonesByNameRequest) obj;
        return Objects.equals(dnsName(), other.dnsName()) && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHostedZonesByNameRequest").add("DNSName", dnsName()).add("HostedZoneId", hostedZoneId())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DNSName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHostedZonesByNameRequest, T> g) {
        return obj -> g.apply((ListHostedZonesByNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, ListHostedZonesByNameRequest> {
        /**
         * <p>
         * (Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code>
         * parameter only if you want to specify the name of the first hosted zone in the response. If you don't include
         * the <code>dnsname</code> parameter, Amazon Route 53 returns all of the hosted zones that were created by the
         * current account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and
         * <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code>
         * from the previous response.
         * </p>
         * 
         * @param dnsName
         *        (Optional) For your first request to <code>ListHostedZonesByName</code>, include the
         *        <code>dnsname</code> parameter only if you want to specify the name of the first hosted zone in the
         *        response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of the
         *        hosted zones that were created by the current account, in ASCII order. For subsequent requests,
         *        include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For <code>dnsname</code>,
         *        specify the value of <code>NextDNSName</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
         * <code>hostedzoneid</code> parameter.
         * </p>
         * <p>
         * If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code>
         * returns only the first <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code>
         * hosted zones, submit another request to <code>ListHostedZonesByName</code> and include both
         * <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of <code>hostedzoneid</code>,
         * specify the value of the <code>NextHostedZoneId</code> element from the previous response.
         * </p>
         * 
         * @param hostedZoneId
         *        (Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the
         *        <code>hostedzoneid</code> parameter.</p>
         *        <p>
         *        If you have more hosted zones than the value of <code>maxitems</code>,
         *        <code>ListHostedZonesByName</code> returns only the first <code>maxitems</code> hosted zones. To get
         *        the next group of <code>maxitems</code> hosted zones, submit another request to
         *        <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code>
         *        parameters. For the value of <code>hostedzoneid</code>, specify the value of the
         *        <code>NextHostedZoneId</code> element from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The maximum number of hosted zones to be included in the response body for this request. If you have more
         * than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element in the
         * response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code> specify the
         * first hosted zone in the next group of <code>maxitems</code> hosted zones.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of hosted zones to be included in the response body for this request. If you have
         *        more than <code>maxitems</code> hosted zones, then the value of the <code>IsTruncated</code> element
         *        in the response is true, and the values of <code>NextDNSName</code> and <code>NextHostedZoneId</code>
         *        specify the first hosted zone in the next group of <code>maxitems</code> hosted zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String dnsName;

        private String hostedZoneId;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameRequest model) {
            super(model);
            dnsName(model.dnsName);
            hostedZoneId(model.hostedZoneId);
            maxItems(model.maxItems);
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        @Transient
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        @Transient
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        @Transient
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHostedZonesByNameRequest build() {
            return new ListHostedZonesByNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
