/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the <code>AssociateVPCWithHostedZone</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateVpcWithHostedZoneResponse extends Route53Response implements
        ToCopyableBuilder<AssociateVpcWithHostedZoneResponse.Builder, AssociateVpcWithHostedZoneResponse> {
    private static final SdkField<ChangeInfo> CHANGE_INFO_FIELD = SdkField
            .<ChangeInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ChangeInfo")
            .getter(getter(AssociateVpcWithHostedZoneResponse::changeInfo))
            .setter(setter(Builder::changeInfo))
            .constructor(ChangeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeInfo")
                    .unmarshallLocationName("ChangeInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_INFO_FIELD));

    private final ChangeInfo changeInfo;

    private AssociateVpcWithHostedZoneResponse(BuilderImpl builder) {
        super(builder);
        this.changeInfo = builder.changeInfo;
    }

    /**
     * <p>
     * A complex type that describes the changes made to your hosted zone.
     * </p>
     * 
     * @return A complex type that describes the changes made to your hosted zone.
     */
    public final ChangeInfo changeInfo() {
        return changeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVpcWithHostedZoneResponse)) {
            return false;
        }
        AssociateVpcWithHostedZoneResponse other = (AssociateVpcWithHostedZoneResponse) obj;
        return Objects.equals(changeInfo(), other.changeInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateVpcWithHostedZoneResponse").add("ChangeInfo", changeInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeInfo":
            return Optional.ofNullable(clazz.cast(changeInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateVpcWithHostedZoneResponse, T> g) {
        return obj -> g.apply((AssociateVpcWithHostedZoneResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateVpcWithHostedZoneResponse> {
        /**
         * <p>
         * A complex type that describes the changes made to your hosted zone.
         * </p>
         * 
         * @param changeInfo
         *        A complex type that describes the changes made to your hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeInfo(ChangeInfo changeInfo);

        /**
         * <p>
         * A complex type that describes the changes made to your hosted zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeInfo.Builder} avoiding the need to
         * create one manually via {@link ChangeInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChangeInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #changeInfo(ChangeInfo)}.
         * 
         * @param changeInfo
         *        a consumer that will call methods on {@link ChangeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeInfo(ChangeInfo)
         */
        default Builder changeInfo(Consumer<ChangeInfo.Builder> changeInfo) {
            return changeInfo(ChangeInfo.builder().applyMutation(changeInfo).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private ChangeInfo changeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVpcWithHostedZoneResponse model) {
            super(model);
            changeInfo(model.changeInfo);
        }

        public final ChangeInfo.Builder getChangeInfo() {
            return changeInfo != null ? changeInfo.toBuilder() : null;
        }

        public final void setChangeInfo(ChangeInfo.BuilderImpl changeInfo) {
            this.changeInfo = changeInfo != null ? changeInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        @Override
        public AssociateVpcWithHostedZoneResponse build() {
            return new AssociateVpcWithHostedZoneResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
